/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.platform.sender;

import com.github.retrooper.packetevents.protocol.sound.SoundCategory;
import com.github.retrooper.packetevents.protocol.sound.Sounds;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.PacketWrapper;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntitySoundEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSoundEffect;
import java.util.Arrays;
import java.util.Optional;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.sender.PacketSender;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;

@Singleton
public class SoundPlayer {
    private final FPlayerService fPlayerService;
    private final PlatformPlayerAdapter platformPlayerAdapter;
    private final PacketSender packetSender;
    private final PermissionChecker permissionChecker;

    @Inject
    public SoundPlayer(FPlayerService fPlayerService, PlatformPlayerAdapter platformPlayerAdapter, PacketSender packetSender, PermissionChecker permissionChecker) {
        this.fPlayerService = fPlayerService;
        this.platformPlayerAdapter = platformPlayerAdapter;
        this.packetSender = packetSender;
        this.permissionChecker = permissionChecker;
    }

    public void play(Sound sound, FEntity sender) {
        if (sender instanceof FPlayer) {
            FPlayer fPlayer = (FPlayer)sender;
            this.play(sound, (FEntity)fPlayer, fPlayer);
        }
    }

    public void play(Sound sound, FEntity sender, FPlayer receiver) {
        if (!sound.isEnable()) {
            return;
        }
        if (!this.permissionChecker.check(sender, sound.getPermission())) {
            return;
        }
        Optional<SoundCategory> category = this.getSoundCategory(sound);
        if (category.isEmpty()) {
            return;
        }
        com.github.retrooper.packetevents.protocol.sound.Sound packetSound = Sounds.getByName((String)sound.getName());
        if (packetSound == null) {
            return;
        }
        this.packetSender.send(receiver, (PacketWrapper<?>)new WrapperPlayServerEntitySoundEffect(packetSound, category.get(), this.platformPlayerAdapter.getEntityId(receiver.getUuid()), sound.getVolume(), sound.getPitch()));
    }

    public void play(Sound sound, FPlayer sender, Vector3i vector3i) {
        if (!sound.isEnable()) {
            return;
        }
        if (!this.permissionChecker.check((FEntity)sender, sound.getPermission())) {
            return;
        }
        Optional<SoundCategory> category = this.getSoundCategory(sound);
        if (category.isEmpty()) {
            return;
        }
        com.github.retrooper.packetevents.protocol.sound.Sound packetSound = Sounds.getByName((String)sound.getName());
        if (packetSound == null) {
            return;
        }
        this.fPlayerService.getOnlineFPlayers().stream().filter(fReceiver -> {
            double distance = this.platformPlayerAdapter.distance(sender, (FPlayer)fReceiver);
            return distance >= 0.0 && distance <= 16.0;
        }).forEach(fReceiver -> this.packetSender.send((FPlayer)fReceiver, (PacketWrapper<?>)new WrapperPlayServerSoundEffect(packetSound, (SoundCategory)category.get(), vector3i.multiply(8), sound.getVolume(), sound.getPitch())));
    }

    private Optional<SoundCategory> getSoundCategory(Sound sound) {
        return Arrays.stream(SoundCategory.values()).filter(soundCategory -> soundCategory.name().equalsIgnoreCase(sound.getCategory())).findAny();
    }
}

