/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.context;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.util.constant.MessageFlag;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public class MessageContext {
    private final Map<MessageFlag, Boolean> flags = new EnumMap<MessageFlag, Boolean>(MessageFlag.class);
    private final Set<TagResolver> tagResolvers = new HashSet<TagResolver>();
    private final FEntity sender;
    private final FPlayer receiver;
    private final UUID messageUUID;
    private String message;
    private String userMessage;

    public MessageContext(UUID messageUUID, FEntity sender, FPlayer receiver, String message) {
        this.messageUUID = messageUUID;
        this.sender = sender;
        this.receiver = receiver;
        this.message = message;
    }

    public void addTagResolvers(TagResolver ... resolvers) {
        if (resolvers == null || resolvers.length == 0) {
            return;
        }
        this.tagResolvers.addAll(Arrays.asList(resolvers));
    }

    public void addReplacementTag(TagResolver tagResolver) {
        this.tagResolvers.add(tagResolver);
    }

    public void addReplacementTag(MessagePipeline.ReplacementTag replacementTag, BiFunction<ArgumentQueue, Context, Tag> handler) {
        this.addReplacementTag(TagResolver.resolver((String)replacementTag.getTagName(), handler));
    }

    public void addReplacementTag(Set<MessagePipeline.ReplacementTag> replacementTags, BiFunction<ArgumentQueue, Context, Tag> handler) {
        Set tags = replacementTags.stream().map(MessagePipeline.ReplacementTag::getTagName).collect(Collectors.toSet());
        this.addReplacementTag(TagResolver.resolver(tags, handler));
    }

    public boolean isFlag(MessageFlag flag) {
        return this.flags.getOrDefault((Object)flag, flag.getDefaultValue());
    }

    public void setFlag(MessageFlag flag, boolean value) {
        this.flags.put(flag, value);
    }

    public void setFlags(Map<MessageFlag, Boolean> flags) {
        this.flags.putAll(flags);
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    @Generated
    public Map<MessageFlag, Boolean> getFlags() {
        return this.flags;
    }

    @Generated
    public Set<TagResolver> getTagResolvers() {
        return this.tagResolvers;
    }

    @Generated
    public FEntity getSender() {
        return this.sender;
    }

    @Generated
    public FPlayer getReceiver() {
        return this.receiver;
    }

    @Generated
    public UUID getMessageUUID() {
        return this.messageUUID;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getUserMessage() {
        return this.userMessage;
    }
}

