/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.converter;

import java.util.List;
import lombok.Generated;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.util.logging.FLogger;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ColorConverter {
    private final int defaultBackground = 0x40000000;
    private final List<String> legacyColors = List.of("&0", "&1", "&2", "&3", "&4", "&5", "&6", "&7", "&8", "&9", "&a", "&b", "&c", "&d", "&e", "&f", "&k", "&l", "&m", "&n", "&o");
    private final List<String> namedColors = NamedTextColor.NAMES.values().stream().map(namedTextColor -> "<" + namedTextColor.toString() + ">").toList();
    private final FLogger fLogger;

    @Inject
    public ColorConverter(FLogger fLogger) {
        this.fLogger = fLogger;
    }

    @Nullable
    public String isCorrect(String color) {
        String[] colorParts;
        if (color == null) {
            return null;
        }
        if (this.isHex(color)) {
            return color;
        }
        if (color.startsWith("<gradient:#") && color.endsWith(">") && color.length() == 26 && (colorParts = color.split(":")).length == 3 && this.isHex(colorParts[1]) && this.isHex(colorParts[2].substring(0, 7))) {
            return color;
        }
        if (this.legacyColors.contains(color)) {
            return color;
        }
        if (this.namedColors.contains(color)) {
            return color;
        }
        return null;
    }

    private boolean isHex(String color) {
        if (color.length() != 7 || !color.startsWith("#")) {
            return false;
        }
        for (int i = 1; i < color.length(); ++i) {
            char c = color.charAt(i);
            int digit = Character.digit(c, 16);
            if (digit != -1) continue;
            return false;
        }
        return true;
    }

    public int parseHexToArgb(String hex) {
        if ((hex = Strings.CS.replace(hex.trim(), "#", "")).length() != 3 && hex.length() != 4 && hex.length() != 6 && hex.length() != 8) {
            this.fLogger.warning("Incorrect HEX string length");
            return 0x40000000;
        }
        if (hex.length() == 3 || hex.length() == 4) {
            StringBuilder stringBuilder = new StringBuilder();
            for (char value : hex.toCharArray()) {
                stringBuilder.append(value).append(value);
            }
            hex = stringBuilder.toString();
        }
        int alpha = 255;
        int rgbPartLength = hex.length();
        if (hex.length() == 8) {
            alpha = Integer.parseInt(hex.substring(6, 8), 16);
            rgbPartLength = 6;
        }
        try {
            int r = Integer.parseInt(hex.substring(0, 2), 16);
            int g = Integer.parseInt(hex.substring(2, 4), 16);
            int b = Integer.parseInt(hex.substring(4, rgbPartLength), 16);
            return alpha << 24 | r << 16 | g << 8 | b;
        }
        catch (NumberFormatException e) {
            this.fLogger.warning("Incorrect HEX characters");
            return 0x40000000;
        }
    }

    @Generated
    public int getDefaultBackground() {
        return this.defaultBackground;
    }

    @Generated
    public List<String> getLegacyColors() {
        return this.legacyColors;
    }

    @Generated
    public List<String> getNamedColors() {
        return this.namedColors;
    }

    @Generated
    public FLogger getFLogger() {
        return this.fLogger;
    }
}

