/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.parser.integer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.processing.converter.ColorConverter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.checker.PermissionChecker;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.context.CommandInput;
import org.incendo.cloud.parser.ArgumentParseResult;
import org.incendo.cloud.parser.ArgumentParser;
import org.incendo.cloud.parser.standard.StringParser;
import org.incendo.cloud.suggestion.BlockingSuggestionProvider;

@Singleton
public class ColorParser
implements ArgumentParser<FPlayer, String>,
BlockingSuggestionProvider.Strings<FPlayer> {
    private final Message.Format.FColor message;
    private final Permission.Command.Chatcolor chatcolorPermission;
    private final PermissionChecker permissionChecker;
    private final ColorConverter colorConverter;
    private final StringParser<FPlayer> stringParser;
    private final List<String> hexSymbols = List.of("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f");

    @Inject
    public ColorParser(FileResolver fileResolver, PermissionChecker permissionChecker, ColorConverter colorConverter) {
        this.message = fileResolver.getMessage().getFormat().getFcolor();
        this.chatcolorPermission = fileResolver.getPermission().getCommand().getChatcolor();
        this.permissionChecker = permissionChecker;
        this.colorConverter = colorConverter;
        this.stringParser = new StringParser(StringParser.StringMode.SINGLE);
    }

    @NonNull
    public ArgumentParseResult<String> parse(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return this.stringParser.parse(context, input);
    }

    @NonNull
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<FPlayer> context, @NonNull CommandInput input) {
        ArrayList<String> suggestions;
        block7: {
            String current;
            block8: {
                block6: {
                    if (context == null) {
                        throw new NullPointerException("context is marked non-null but is null");
                    }
                    if (input == null) {
                        throw new NullPointerException("input is marked non-null but is null");
                    }
                    String currentInput = input.input();
                    String[] args = (currentInput = currentInput.substring(currentInput.indexOf(" ") + 1)).split(" ");
                    current = args.length == 0 || currentInput.endsWith(" ") ? "" : args[args.length - 1];
                    int maxColors = this.message.getDefaultColors().size();
                    boolean hasOtherPermission = this.permissionChecker.check((FEntity)context.sender(), this.chatcolorPermission.getOther());
                    if (!hasOtherPermission && args.length >= maxColors || hasOtherPermission && args.length >= maxColors + 1) {
                        return Collections.emptyList();
                    }
                    suggestions = new ArrayList<String>();
                    List<String> constants = List.of("clear", "<gradient:#", "<", "#", "&");
                    for (String constant : constants) {
                        if (!current.isEmpty() && !constant.startsWith(current)) continue;
                        suggestions.add(constant);
                    }
                    if (!current.startsWith("#") || current.length() >= 7) break block6;
                    for (String symbol : this.hexSymbols) {
                        suggestions.add(current + symbol);
                    }
                    break block7;
                }
                if (!current.startsWith("&") || current.length() != 1) break block8;
                suggestions.addAll(this.colorConverter.getLegacyColors());
                break block7;
            }
            if (current.isEmpty()) break block7;
            for (String color : this.colorConverter.getNamedColors()) {
                if (!color.startsWith(current)) continue;
                suggestions.add(color);
            }
        }
        return suggestions;
    }
}

