/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.processor;

import java.util.UUID;
import java.util.function.Consumer;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.player.PlayerPreLoginEvent;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.service.FPlayerService;

@Singleton
public class PlayerPreLoginProcessor {
    private final FPlayerService fPlayerService;
    private final ProxyRegistry proxyRegistry;
    private final EventDispatcher eventDispatcher;

    @Inject
    public PlayerPreLoginProcessor(FPlayerService fPlayerService, ProxyRegistry proxyRegistry, EventDispatcher eventDispatcher) {
        this.fPlayerService = fPlayerService;
        this.proxyRegistry = proxyRegistry;
        this.eventDispatcher = eventDispatcher;
    }

    @Async
    public void processAsyncLogin(UUID uuid, String name, Consumer<PlayerPreLoginEvent> allowedConsumer, Consumer<PlayerPreLoginEvent> kickConsumer) {
        this.processLogin(uuid, name, allowedConsumer, kickConsumer);
    }

    public void processLogin(UUID uuid, String name, Consumer<PlayerPreLoginEvent> allowedConsumer, Consumer<PlayerPreLoginEvent> kickConsumer) {
        if (this.fPlayerService.getOnlineFPlayers().isEmpty() && this.proxyRegistry.hasEnabledProxy()) {
            this.fPlayerService.clear();
            this.fPlayerService.addConsole();
        }
        FPlayer fPlayer = this.fPlayerService.addFPlayer(uuid, name);
        PlayerPreLoginEvent event = new PlayerPreLoginEvent(fPlayer);
        this.eventDispatcher.dispatch(event);
        if (event.isAllowed()) {
            this.fPlayerService.loadData(fPlayer);
            allowedConsumer.accept(event);
        } else {
            kickConsumer.accept(event);
        }
    }
}

