/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.resolver;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Localization;
import net.flectone.pulse.config.Message;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.elytrium.language.object.AbstractSerializable;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class FileResolver {
    private final Map<String, Localization> localizationMap = new HashMap<String, Localization>();
    private final Path projectPath;
    private final Command command;
    private final Config config;
    private final Integration integration;
    private final Message message;
    private final Permission permission;
    private final FLogger fLogger;
    private String preInitVersion;
    private Localization defaultLocalization;

    @Inject
    public FileResolver(@Named(value="projectPath") Path projectPath, FLogger fLogger) {
        this.projectPath = projectPath;
        this.command = new Command(projectPath);
        this.config = new Config(projectPath);
        this.integration = new Integration(projectPath);
        this.message = new Message(projectPath);
        this.permission = new Permission(projectPath);
        this.fLogger = fLogger;
    }

    public Localization getLocalization() {
        return this.getLocalization(FPlayer.UNKNOWN);
    }

    public Localization getLocalization(FEntity sender) {
        if (!this.config.isLanguagePlayer()) {
            return this.defaultLocalization;
        }
        if (!(sender instanceof FPlayer)) {
            return this.defaultLocalization;
        }
        FPlayer fPlayer = (FPlayer)sender;
        return this.localizationMap.getOrDefault(fPlayer.getSettingValue(FPlayer.Setting.LOCALE), this.defaultLocalization);
    }

    public void reload() {
        this.config.reload();
        this.config.setLanguage(this.config.getLanguage());
        this.preInitVersion = this.config.getVersion();
        if (!this.preInitVersion.equals("1.5.1")) {
            if (this.isVersionOlderThan(this.preInitVersion, "1.4.3")) {
                this.migration_1_4_3();
            }
            if (this.isVersionOlderThan(this.preInitVersion, "1.5.0")) {
                this.migration_1_5_0();
            }
            this.config.setVersion("1.5.1");
            this.config.save();
        }
        this.command.reload();
        this.integration.reload();
        this.message.reload();
        this.permission.reload();
        this.reloadLanguages();
        this.defaultLocalization = this.localizationMap.get(this.config.getLanguage());
    }

    public void save() {
        this.command.save();
        this.config.save();
        this.integration.save();
        this.message.save();
        this.permission.save();
        this.localizationMap.values().forEach(AbstractSerializable::save);
    }

    private void reloadLanguages() {
        HashSet<String> newLanguages = new HashSet<String>(Set.of("ru_ru", "en_us"));
        newLanguages.add(this.config.getLanguage());
        try (Stream<Path> paths2 = Files.walk(this.projectPath.resolve("localizations"), new FileVisitOption[0]);){
            paths2.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                File localization = path.toFile();
                String localizationName = localization.getName();
                if (localizationName.endsWith(".yml")) {
                    newLanguages.add(Strings.CS.replace(localizationName, ".yml", ""));
                }
            });
        }
        catch (NoSuchFileException paths2) {
        }
        catch (IOException e) {
            this.fLogger.warning(e);
        }
        newLanguages.forEach(this::loadLanguage);
    }

    private void loadLanguage(String language) {
        Localization localization = new Localization(this.projectPath, language);
        localization.reload(localization.getPath());
        this.localizationMap.put(language, localization);
    }

    public boolean isVersionOlderThan(String first, String second) {
        String[] subFirst = this.parseVersionNumbers(first);
        if (subFirst.length != 3) {
            return false;
        }
        String[] subSecond = this.parseVersionNumbers(second);
        if (subSecond.length != 3) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            int intSecond;
            int intFirst = Integer.parseInt(subFirst[i]);
            if (intFirst < (intSecond = Integer.parseInt(subSecond[i]))) {
                return true;
            }
            if (intFirst <= intSecond) continue;
            return false;
        }
        return false;
    }

    private String[] parseVersionNumbers(String string) {
        int endIndex = string.indexOf(45);
        return (endIndex == -1 ? string : string.substring(0, endIndex)).split("\\.");
    }

    private void migration_1_4_3() {
        this.permission.reload();
        Permission.Message.Update update = this.permission.getMessage().getUpdate();
        if (update.getName().equals("flectonepulse.module.message.op")) {
            update.setName("flectonepulse.module.message.update");
            update.setSound(new Permission.PermissionEntry("flectonepulse.module.message.update.sound", Permission.Type.TRUE));
            this.permission.save();
        }
    }

    private void migration_1_5_0() {
        Integration.Twitch twitch;
        Integration.Telegram telegram;
        String oldChatKey = "CHAT";
        String newChatKey = "CHAT_GLOBAL";
        this.integration.reload();
        Integration.Discord discord = this.integration.getDiscord();
        if (discord.getMessageChannel().containsKey(oldChatKey)) {
            discord.getMessageChannel().put(newChatKey, discord.getMessageChannel().remove(oldChatKey));
        }
        if ((telegram = this.integration.getTelegram()).getMessageChannel().containsKey(oldChatKey)) {
            telegram.getMessageChannel().put(newChatKey, telegram.getMessageChannel().remove(oldChatKey));
        }
        if ((twitch = this.integration.getTwitch()).getMessageChannel().containsKey(oldChatKey)) {
            twitch.getMessageChannel().put(newChatKey, twitch.getMessageChannel().remove(oldChatKey));
        }
        this.integration.save();
        this.reloadLanguages();
        this.localizationMap.values().forEach(localization -> {
            Localization.Integration.Telegram localizationTelegram;
            Localization.Integration.Twitch localizationTwitch;
            Localization.Integration.Discord localizationDiscord = localization.getIntegration().getDiscord();
            if (localizationDiscord.getMessageChannel().containsKey(oldChatKey)) {
                localizationDiscord.getMessageChannel().put(newChatKey, localizationDiscord.getMessageChannel().remove(oldChatKey));
            }
            if ((localizationTwitch = localization.getIntegration().getTwitch()).getMessageChannel().containsKey(oldChatKey)) {
                localizationTwitch.getMessageChannel().put(newChatKey, localizationTwitch.getMessageChannel().remove(oldChatKey));
            }
            if ((localizationTelegram = localization.getIntegration().getTelegram()).getMessageChannel().containsKey(oldChatKey)) {
                localizationTelegram.getMessageChannel().put(newChatKey, localizationTelegram.getMessageChannel().remove(oldChatKey));
            }
            localization.save();
        });
    }

    @Generated
    public Map<String, Localization> getLocalizationMap() {
        return this.localizationMap;
    }

    @Generated
    public Path getProjectPath() {
        return this.projectPath;
    }

    @Generated
    public Command getCommand() {
        return this.command;
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public Integration getIntegration() {
        return this.integration;
    }

    @Generated
    public Message getMessage() {
        return this.message;
    }

    @Generated
    public Permission getPermission() {
        return this.permission;
    }

    @Generated
    public String getPreInitVersion() {
        return this.preInitVersion;
    }
}

