/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.resolver;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.library.libby.LibraryManager;
import net.flectone.pulse.library.libby.relocation.Relocation;

public abstract class LibraryResolver {
    private final List<Library> libraries = new ArrayList<Library>();
    private final LibraryManager libraryManager;

    protected LibraryResolver(LibraryManager libraryManager) {
        this.libraryManager = libraryManager;
    }

    public void addLibrary(Library library) {
        this.libraries.add(library);
    }

    public void loadLibrary(Library library) {
        this.libraryManager.loadLibrary(library);
    }

    public void loadLibraries(List<Library> libraries) {
        libraries.forEach(this::loadLibrary);
    }

    public void loadLibraries() {
        this.loadLibraries(this.libraries);
    }

    public void resolveRepositories() {
        this.libraryManager.addMavenCentral();
        this.libraryManager.addJitPack();
        this.libraryManager.addJCenter();
        this.libraryManager.addSonatype();
        this.libraryManager.addRepository("https://hub.spigotmc.org/nexus/content/repositories/snapshots/");
        this.libraryManager.addRepository("https://repo.aikar.co/content/groups/aikar/");
        this.libraryManager.addRepository("https://repo.minebench.de");
        this.libraryManager.addRepository("https://s01.oss.sonatype.org/content/repositories/snapshots");
        this.libraryManager.addRepository("https://repo.codemc.io/repository/maven-releases");
        this.libraryManager.addRepository("https://repo.codemc.io/repository/maven-snapshots/");
        this.libraryManager.addRepository("https://maven.fabricmc.net/");
    }

    public void addLibraries() {
        this.addLibrary(Library.builder().groupId("com{}google{}inject").artifactId("guice").version("7.0.0").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("com{}google{}inject").relocatedPattern("net.flectone.pulse.library.guice").build()).relocate(Relocation.builder().pattern("com{}google{}common").relocatedPattern("net.flectone.pulse.library.guava").build()).build());
        this.addLibrary(Library.builder().groupId("net{}elytrium").artifactId("serializer").version("1.1.1").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("net{}elytrium{}serializer").relocatedPattern("net.flectone.pulse.library.elytrium").build()).build());
        this.addLibrary(Library.builder().groupId("com{}zaxxer").artifactId("HikariCP").version("7.0.2").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("com{}zaxxer").relocatedPattern("net.flectone.pulse.library.hikaricp").build()).build());
        this.addLibrary(Library.builder().groupId("org{}jdbi").artifactId("jdbi3-core").version("3.49.5").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("org{}jdbi").relocatedPattern("net.flectone.pulse.library.jdbi3").build()).build());
        this.addLibrary(Library.builder().groupId("org{}jdbi").artifactId("jdbi3-sqlobject").version("3.49.5").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("org{}jdbi").relocatedPattern("net.flectone.pulse.library.jdbi3").build()).build());
        this.addLibrary(Library.builder().groupId("org{}apache{}commons").artifactId("commons-text").version("1.14.0").resolveTransitiveDependencies(true).relocate(Relocation.builder().pattern("org{}apache{}commons").relocatedPattern("net.flectone.pulse.library.apache").build()).build());
    }

    @Generated
    public LibraryManager getLibraryManager() {
        return this.libraryManager;
    }
}

