/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.resolver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;

@Singleton
public class SystemVariableResolver {
    private final Pattern envVarPattern = Pattern.compile("\\$\\{([A-Za-z0-9_.-]+)(?::([^}]*))?}");

    @Inject
    public SystemVariableResolver() {
    }

    public String substituteEnvVars(String text) {
        String variable = this.process(text);
        if (variable.isBlank()) {
            return text;
        }
        return variable;
    }

    private String process(String text) {
        StringBuilder stringBuilder = new StringBuilder();
        Matcher matcher = this.envVarPattern.matcher(text);
        int index = 0;
        while (matcher.find()) {
            String value;
            stringBuilder.append(text, index, matcher.start());
            String variable = matcher.group(1);
            String obj = System.getenv(variable);
            if (obj != null) {
                value = String.valueOf(obj);
            } else {
                value = matcher.group(2);
                if (value == null) {
                    value = "";
                }
            }
            stringBuilder.append(value);
            index = matcher.end();
        }
        stringBuilder.append(text, index, text.length());
        return stringBuilder.toString();
    }
}

