/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.serializer;

import java.util.Arrays;
import net.flectone.pulse.library.elytrium.custom.ClassSerializer;

public class EnumSerializer<E extends Enum<E>>
extends ClassSerializer<E, String> {
    private final Class<E> enumClass;

    public EnumSerializer(Class<?> enumClass) {
        super(enumClass, String.class);
        this.enumClass = enumClass;
    }

    public String serialize(E enumValue) {
        return ((Enum)enumValue).name();
    }

    public E deserialize(String string) {
        return (E)Arrays.stream((Enum[])this.enumClass.getEnumConstants()).filter(enumValue -> enumValue.name().equalsIgnoreCase(string)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unknown enum value: " + string + " for enum " + this.enumClass.getName()));
    }
}

