/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.processing.serializer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;

@Singleton
public class PacketSerializer {
    public static final String MINECRAFT_BRAND = "minecraft:brand";

    @Inject
    public PacketSerializer() {
    }

    public byte[] serialize(String string) {
        ByteBuf buf = Unpooled.buffer();
        this.writeString(buf, string);
        byte[] result = new byte[buf.readableBytes()];
        buf.readBytes(result);
        return result;
    }

    private void writeString(ByteBuf buf, String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        this.writeVarInt(buf, bytes.length);
        buf.writeBytes(bytes);
    }

    private void writeVarInt(ByteBuf buf, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            buf.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        buf.writeByte(value);
    }
}

