/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.service;

import java.time.Instant;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.dto.MetricsDTO;
import net.flectone.pulse.module.Module;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.provider.PacketProvider;
import net.flectone.pulse.platform.sender.MetricsSender;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class MetricsService {
    private final TaskScheduler taskScheduler;
    private final MetricsSender metricsSender;
    private final PlatformServerAdapter platformServerAdapter;
    private final PacketProvider packetProvider;
    private final FileResolver fileResolver;
    private final Module module;

    @Inject
    public MetricsService(TaskScheduler taskScheduler, MetricsSender metricsSender, PlatformServerAdapter platformServerAdapter, PacketProvider packetProvider, FileResolver fileResolver, Module module) {
        this.taskScheduler = taskScheduler;
        this.metricsSender = metricsSender;
        this.platformServerAdapter = platformServerAdapter;
        this.packetProvider = packetProvider;
        this.fileResolver = fileResolver;
        this.module = module;
    }

    public void reload() {
        this.taskScheduler.runAsyncTimer(this::send, 0L, 72000L);
    }

    public void send() {
        MetricsDTO metricsDTO = new MetricsDTO();
        metricsDTO.setServerCore(this.platformServerAdapter.getServerCore());
        metricsDTO.setServerVersion(this.packetProvider.getServerVersion().getReleaseName());
        metricsDTO.setOsName(this.getOsName());
        metricsDTO.setOsArchitecture(this.getOsArch());
        metricsDTO.setOsVersion(this.getOsVersion());
        metricsDTO.setJavaVersion(this.getJavaVersion());
        metricsDTO.setCpuCores(Runtime.getRuntime().availableProcessors());
        metricsDTO.setTotalRAM(Runtime.getRuntime().maxMemory());
        Config config = this.fileResolver.getConfig();
        metricsDTO.setProjectVersion(config.getVersion());
        metricsDTO.setProjectLanguage(config.getLanguage());
        metricsDTO.setOnlineMode(this.platformServerAdapter.isOnlineMode() ? "True" : "False");
        metricsDTO.setProxyMode(config.isBungeecord() ? "BungeeCord" : (config.isVelocity() ? "Velocity" : "None"));
        metricsDTO.setDatabaseMode(config.getDatabase().getType().name());
        metricsDTO.setPlayerCount(this.platformServerAdapter.getOnlinePlayerCount());
        metricsDTO.setModules(this.module.collectModuleStatuses());
        metricsDTO.setCreatedAt(Instant.now().toString());
        this.metricsSender.sendMetrics(metricsDTO);
    }

    private String getOsName() {
        return System.getProperty("os.name");
    }

    private String getOsArch() {
        return System.getProperty("os.arch");
    }

    private String getOsVersion() {
        return System.getProperty("os.version");
    }

    private String getJavaVersion() {
        return System.getProperty("java.version");
    }
}

