/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.service;

import java.util.List;
import java.util.UUID;
import net.flectone.pulse.data.repository.ModerationRepository;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Moderation;

@Singleton
public class ModerationService {
    private final ModerationRepository moderationRepository;

    @Inject
    public ModerationService(ModerationRepository moderationRepository) {
        this.moderationRepository = moderationRepository;
    }

    public void reload() {
        this.moderationRepository.invalidateAll();
    }

    public void invalidate(UUID uuid) {
        this.moderationRepository.invalidateAll(uuid);
    }

    public void invalidateMutes(UUID uuid) {
        this.moderationRepository.invalidate(uuid, Moderation.Type.MUTE);
    }

    public void invalidateBans(UUID uuid) {
        this.moderationRepository.invalidate(uuid, Moderation.Type.BAN);
    }

    public void invalidateWarns(UUID uuid) {
        this.moderationRepository.invalidate(uuid, Moderation.Type.WARN);
    }

    public Moderation ban(FPlayer fPlayer, long time, String reason, int moderator) {
        return this.add(fPlayer, time, reason, moderator, Moderation.Type.BAN);
    }

    public Moderation mute(FPlayer fPlayer, long time, String reason, int moderator) {
        return this.add(fPlayer, time, reason, moderator, Moderation.Type.MUTE);
    }

    public Moderation warn(FPlayer fPlayer, long time, String reason, int moderator) {
        return this.add(fPlayer, time, reason, moderator, Moderation.Type.WARN);
    }

    public List<Moderation> getValidMutes(FPlayer fPlayer) {
        return this.getValid(fPlayer, Moderation.Type.MUTE);
    }

    public List<Moderation> getValidMutes() {
        return this.getValid(Moderation.Type.MUTE);
    }

    public List<Moderation> getValidBans(FPlayer fPlayer) {
        return this.getValid(fPlayer, Moderation.Type.BAN);
    }

    public List<Moderation> getValidBans() {
        return this.getValid(Moderation.Type.BAN);
    }

    public List<Moderation> getValidWarns(FPlayer fPlayer) {
        return this.getValid(fPlayer, Moderation.Type.WARN);
    }

    public List<Moderation> getValidWarns() {
        return this.getValid(Moderation.Type.WARN);
    }

    public List<Moderation> getValid(FPlayer fPlayer, Moderation.Type type) {
        return this.moderationRepository.getValid(fPlayer, type);
    }

    public List<Moderation> getValid(Moderation.Type type) {
        return this.moderationRepository.getValid(type);
    }

    public List<String> getValidNames(Moderation.Type type) {
        return this.moderationRepository.getValidNames(type);
    }

    public Moderation kick(FPlayer fPlayer, String reason, int moderator) {
        return this.moderationRepository.save(fPlayer, -1L, reason, moderator, Moderation.Type.KICK);
    }

    public Moderation add(FPlayer fPlayer, long time, String reason, int moderator, Moderation.Type type) {
        this.moderationRepository.invalidate(fPlayer.getUuid(), type);
        return this.moderationRepository.save(fPlayer, time, reason, moderator, type);
    }

    public void remove(FPlayer fPlayer, List<Moderation> moderations) {
        if (moderations.isEmpty()) {
            return;
        }
        this.moderationRepository.invalidate(fPlayer.getUuid(), moderations.get(0).getType());
        for (Moderation moderation : moderations) {
            moderation.setInvalid();
            this.moderationRepository.updateValid(moderation);
        }
    }
}

