/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.service;

import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class SkinService {
    private final Integration integration;
    private final IntegrationModule integrationModule;

    @Inject
    public SkinService(FileResolver fileResolver, IntegrationModule integrationModule) {
        this.integration = fileResolver.getIntegration();
        this.integrationModule = integrationModule;
    }

    public String getSkin(FEntity entity) {
        String texture = this.integrationModule.getTextureUrl(entity);
        return texture != null ? texture : entity.getUuid().toString();
    }

    public String getAvatarUrl(FEntity entity) {
        return Strings.CS.replace(this.integration.getAvatarApiUrl(), "<skin>", this.getSkin(entity));
    }

    public String getBodyUrl(FEntity entity) {
        return Strings.CS.replace(this.integration.getBodyApiUrl(), "<skin>", this.getSkin(entity));
    }
}

