/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class IconUtil {
    private final FLogger fLogger;

    @Inject
    private IconUtil(FLogger fLogger) {
        this.fLogger = fLogger;
    }

    public String convertIcon(File icon) {
        try {
            BufferedImage bufferedImage = ImageIO.read(icon);
            if (bufferedImage.getHeight() != 64 || bufferedImage.getWidth() != 64) {
                this.fLogger.warning("Image " + icon.getName() + " size must be 64x64");
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "PNG", out);
            byte[] bytes = out.toByteArray();
            return new String(Base64.getEncoder().encode(bytes));
        }
        catch (Exception e) {
            this.fLogger.warning("Failed to load " + icon.getName());
            return null;
        }
    }
}

