/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util;

import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;

@Singleton
public class TpsTracker {
    private static final int TICK_HISTORY = 20;
    private static final int MAX_SAMPLES = 2;
    private final long[] tickTimes = new long[20];
    private final double[] tpsSamples = new double[2];
    private int tickCount = 0;
    private int sampleCount = 0;

    @Inject
    public TpsTracker() {
    }

    public void onTick() {
        long now;
        this.tickTimes[this.tickCount % 20] = now = System.nanoTime() / 1000000L;
        ++this.tickCount;
        if (this.tickCount % 20 == 0) {
            this.updateTpsSample();
        }
    }

    private void updateTpsSample() {
        double tps;
        if (this.tickCount < 20) {
            this.tpsSamples[this.sampleCount % 2] = 20.0;
            ++this.sampleCount;
            return;
        }
        int newestIndex = (this.tickCount - 1) % 20;
        long newestTick = this.tickTimes[newestIndex];
        int oldestIndex = (this.tickCount - 20) % 20;
        long oldestTick = this.tickTimes[oldestIndex];
        long elapsed = newestTick - oldestTick;
        this.tpsSamples[this.sampleCount % 2] = tps = elapsed <= 0L ? 20.0 : Math.min(20000.0 / (double)elapsed, 20.0);
        ++this.sampleCount;
    }

    public double getTPS() {
        if (this.sampleCount == 0) {
            return 20.0;
        }
        int samplesToAverage = Math.min(this.sampleCount, 2);
        double sum = 0.0;
        for (int i = 0; i < samplesToAverage; ++i) {
            sum += this.tpsSamples[(this.sampleCount - 1 - i) % 2];
        }
        return sum / (double)samplesToAverage;
    }
}

