/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.checker;

import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.message.format.moderation.newbie.NewbieModule;
import net.flectone.pulse.service.ModerationService;

@Singleton
public class MuteChecker {
    private final ModerationService moderationService;
    private final Provider<IntegrationModule> integrationModuleProvider;
    private final Provider<NewbieModule> newbieModule;

    @Inject
    public MuteChecker(ModerationService moderationService, Provider<IntegrationModule> integrationModuleProvider, Provider<NewbieModule> newbieModuleProvider) {
        this.moderationService = moderationService;
        this.integrationModuleProvider = integrationModuleProvider;
        this.newbieModule = newbieModuleProvider;
    }

    public Status check(FPlayer fPlayer) {
        if (!this.moderationService.getValidMutes(fPlayer).isEmpty()) {
            return Status.LOCAL;
        }
        if (((NewbieModule)this.newbieModule.get()).isNewBie(fPlayer)) {
            return Status.NEWBIE;
        }
        if (((IntegrationModule)this.integrationModuleProvider.get()).isMuted(fPlayer)) {
            return Status.EXTERNAL;
        }
        return Status.NONE;
    }

    public static enum Status {
        LOCAL,
        EXTERNAL,
        NEWBIE,
        NONE;

    }
}

