/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.interceptor;

import java.lang.reflect.Method;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.execution.scheduler.SchedulerRunnable;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.util.logging.FLogger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

@Singleton
public class AsyncInterceptor
implements MethodInterceptor {
    @Inject
    private TaskScheduler taskScheduler;
    @Inject
    private PlatformServerAdapter platformServerAdapter;
    @Inject
    private FLogger fLogger;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!method.isAnnotationPresent(Async.class)) {
            return invocation.proceed();
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalStateException("@Async can only be applied to void methods");
        }
        long delay = method.getAnnotation(Async.class).delay();
        SchedulerRunnable task = () -> this.proceedSafely(invocation);
        if (delay > 0L) {
            this.taskScheduler.runAsyncLater(task, delay);
        } else if (this.platformServerAdapter.isPrimaryThread() || this.isRestrictedAsyncThread()) {
            this.taskScheduler.runAsync(task);
        } else {
            task.run();
        }
        return null;
    }

    private boolean isRestrictedAsyncThread() {
        String threadName = Thread.currentThread().getName();
        return threadName.startsWith("Netty") || threadName.startsWith("Async Chat");
    }

    private void proceedSafely(MethodInvocation invocation) {
        try {
            invocation.proceed();
        }
        catch (Throwable e) {
            this.fLogger.warning(e);
            e.printStackTrace();
        }
    }
}

