/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.util.logging;

import io.github.retrooper.packetevents.adventure.serializer.gson.GsonComponentSerializer;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.util.logging.LogFilter;
import net.kyori.adventure.text.Component;

@Singleton
public class FLogger
extends Logger {
    private final String pluginName = "\u001b[0;34m(FlectonePulse) \u001b[0m";
    private final List<String> pluginInfo = List.of(" \u001b[0;34m ___       ___  __  ___  __        ___ \u001b[0m", " \u001b[0;34m|__  |    |__  /  `  |  /  \\ |\\ | |__  \u001b[0m", " \u001b[0;34m|    |___ |___ \\__,  |  \\__/ | \\| |___ \u001b[0m", " \u001b[0;34m __             __   ___ \u001b[0;96m                       \u001b[0m", " \u001b[0;34m|__) |  | |    /__` |__  \u001b[0;96m                   \u001b[0m", " \u001b[0;34m|    \\__/ |___ .__/ |___\u001b[0;96m   /\\         \u001b[0m", " \u001b[0;96m                          /  \\ v<version>               \u001b[0m", " \u001b[0;96m__/\\___  ____/\\_____  ___/    \\______ \u001b[0m", " \u001b[0;96m       \\/           \\/  \u001b[0m");
    private final Consumer<LogRecord> logConsumer;
    private LogFilter logFilter;

    public FLogger(Consumer<LogRecord> logConsumer) {
        super("", null);
        this.logConsumer = logConsumer;
    }

    public FLogger(Logger logger) {
        super("", null);
        logger.setLevel(Level.OFF);
        this.setParent(logger);
        this.setLevel(Level.ALL);
        this.logConsumer = x$0 -> super.log((LogRecord)x$0);
    }

    public void enableFilter() {
        this.logFilter = new LogFilter();
    }

    public void reload(List<String> messages) {
        if (this.logFilter == null) {
            return;
        }
        this.logFilter.getMessages().clear();
        this.logFilter.getMessages().addAll(messages);
    }

    @Override
    public void log(LogRecord logRecord) {
        String colorLog = switch (logRecord.getLevel().intValue()) {
            case 900 -> "\u001b[0;93m";
            case 800 -> "\u001b[0;96m";
            default -> "";
        };
        logRecord.setLoggerName("");
        logRecord.setMessage("\u001b[0;34m(FlectonePulse) \u001b[0m" + colorLog + logRecord.getMessage() + "\u001b[0m");
        this.logConsumer.accept(logRecord);
    }

    @Override
    public void info(String msg) {
        LogRecord logRecord = new LogRecord(Level.INFO, msg);
        this.log(logRecord);
    }

    public void logEnabling() {
        this.info("Enabling...");
    }

    public void logEnabled() {
        this.info("FlectonePulse v1.5.1 enabled");
    }

    public void logDisabling() {
        this.info("Disabling...");
    }

    public void logDisabled() {
        this.info("FlectonePulse v1.5.1 disabled");
    }

    public void logReloading() {
        this.info("Reloading...");
    }

    public void logReloaded() {
        this.info("FlectonePulse v1.5.1 reloaded");
    }

    public void logPluginInfo() {
        this.pluginInfo.forEach(string -> {
            string = string.replace("<version>", "1.5.1");
            this.info((String)string);
        });
    }

    @Override
    public void warning(String exception) {
        LogRecord logRecord = new LogRecord(Level.WARNING, exception);
        this.log(logRecord);
    }

    public void warning(Throwable throwable) {
        LogRecord logRecord = new LogRecord(Level.WARNING, "An error occurred, report it to https://github.com/Flectone/FlectonePulse/issues");
        logRecord.setThrown(throwable);
        this.log(logRecord);
    }

    public void warningTree(Component component) {
        String json = (String)GsonComponentSerializer.gson().serialize(component);
        this.warning(json);
    }
}

