/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse;

import net.flectone.pulse.BukkitFlectonePulse;
import net.flectone.pulse.FlectonePulse;
import net.flectone.pulse.PlatformInjector;
import net.flectone.pulse.execution.scheduler.BukkitTaskScheduler;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.universalscheduler.universalScheduler.UniversalScheduler;
import net.flectone.pulse.module.command.spy.BukkitSpyModule;
import net.flectone.pulse.module.command.spy.SpyModule;
import net.flectone.pulse.module.integration.BukkitIntegrationModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.module.integration.simplevoice.BukkitSimpleVoiceModule;
import net.flectone.pulse.module.integration.simplevoice.SimpleVoiceModule;
import net.flectone.pulse.module.message.afk.AfkModule;
import net.flectone.pulse.module.message.afk.BukkitAfkModule;
import net.flectone.pulse.module.message.anvil.AnvilModule;
import net.flectone.pulse.module.message.anvil.BukkitAnvilModule;
import net.flectone.pulse.module.message.book.BookModule;
import net.flectone.pulse.module.message.book.BukkitBookModule;
import net.flectone.pulse.module.message.chat.BukkitChatModule;
import net.flectone.pulse.module.message.chat.ChatModule;
import net.flectone.pulse.module.message.join.BukkitJoinModule;
import net.flectone.pulse.module.message.join.JoinModule;
import net.flectone.pulse.module.message.quit.BukkitQuitModule;
import net.flectone.pulse.module.message.quit.QuitModule;
import net.flectone.pulse.module.message.sign.BukkitSignModule;
import net.flectone.pulse.module.message.sign.SignModule;
import net.flectone.pulse.platform.adapter.BukkitPlayerAdapter;
import net.flectone.pulse.platform.adapter.BukkitServerAdapter;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.provider.AttributesProvider;
import net.flectone.pulse.platform.provider.LegacyAttributesProvider;
import net.flectone.pulse.platform.provider.LegacyPassengersProvider;
import net.flectone.pulse.platform.provider.ModernAttributesProvider;
import net.flectone.pulse.platform.provider.ModernPassengersProvider;
import net.flectone.pulse.platform.provider.PassengersProvider;
import net.flectone.pulse.platform.registry.BukkitListenerRegistry;
import net.flectone.pulse.platform.registry.BukkitPermissionRegistry;
import net.flectone.pulse.platform.registry.BukkitProxyRegistry;
import net.flectone.pulse.platform.registry.CommandRegistry;
import net.flectone.pulse.platform.registry.LegacyBukkitCommandRegistry;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.registry.ModernBukkitCommandRegistry;
import net.flectone.pulse.platform.registry.PermissionRegistry;
import net.flectone.pulse.platform.registry.ProxyRegistry;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.util.checker.BukkitPermissionChecker;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

@Singleton
public class BukkitInjector
extends PlatformInjector {
    private final BukkitFlectonePulse instance;
    private final Plugin plugin;

    public BukkitInjector(BukkitFlectonePulse instance, Plugin plugin, LibraryResolver libraryResolver, FLogger fLogger) {
        super(plugin.getDataFolder().toPath(), libraryResolver, fLogger);
        this.instance = instance;
        this.plugin = plugin;
    }

    @Override
    public void setupPlatform(ReflectionResolver reflectionResolver) {
        this.bind(FlectonePulse.class).toInstance((Object)this.instance);
        this.bind(BukkitFlectonePulse.class).toInstance((Object)this.instance);
        this.bind(Plugin.class).toInstance((Object)this.plugin);
        this.bind(PlatformPlayerAdapter.class).to(BukkitPlayerAdapter.class);
        this.bind(PlatformServerAdapter.class).to(BukkitServerAdapter.class);
        if (reflectionResolver.hasClass("org.bukkit.attribute.Attribute")) {
            this.bind(AttributesProvider.class).to(ModernAttributesProvider.class);
        } else {
            this.bind(AttributesProvider.class).to(LegacyAttributesProvider.class);
        }
        if (reflectionResolver.hasMethod(Player.class, "getPassengers", new Class[0])) {
            this.bind(PassengersProvider.class).to(ModernPassengersProvider.class);
        } else {
            this.bind(PassengersProvider.class).to(LegacyPassengersProvider.class);
        }
        this.bind(PermissionRegistry.class).to(BukkitPermissionRegistry.class);
        this.bind(ListenerRegistry.class).to(BukkitListenerRegistry.class);
        this.bind(ProxyRegistry.class).to(BukkitProxyRegistry.class);
        if (reflectionResolver.hasClass("com.mojang.brigadier.arguments.ArgumentType")) {
            this.bind(CommandRegistry.class).to(ModernBukkitCommandRegistry.class);
        } else {
            this.bind(CommandRegistry.class).to(LegacyBukkitCommandRegistry.class);
        }
        this.bind(PermissionChecker.class).to(BukkitPermissionChecker.class);
        this.bind(TaskScheduler.class).to(BukkitTaskScheduler.class);
        this.bind(IntegrationModule.class).to(BukkitIntegrationModule.class);
        if (reflectionResolver.hasClass("de.maxhenkel.voicechat.api.VoicechatPlugin")) {
            this.bind(SimpleVoiceModule.class).to(BukkitSimpleVoiceModule.class);
        }
        this.bind(AnvilModule.class).to(BukkitAnvilModule.class);
        this.bind(BookModule.class).to(BukkitBookModule.class);
        this.bind(AfkModule.class).to(BukkitAfkModule.class);
        this.bind(ChatModule.class).to(BukkitChatModule.class);
        this.bind(SignModule.class).to(BukkitSignModule.class);
        this.bind(SpyModule.class).to(BukkitSpyModule.class);
        this.bind(JoinModule.class).to(BukkitJoinModule.class);
        this.bind(QuitModule.class).to(BukkitQuitModule.class);
        this.bind(net.flectone.pulse.library.universalscheduler.universalScheduler.scheduling.schedulers.TaskScheduler.class).toInstance((Object)UniversalScheduler.getScheduler((Plugin)this.plugin));
    }
}

