/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import net.flectone.pulse.processing.processor.ProxyMessageProcessor;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.logging.FLogger;
import org.slf4j.Logger;

@Plugin(id="flectonepulse", name="FlectonePulseVelocity", version="1.6.2", authors={"TheFaser"}, description="FlectonePulse - every message under your control!", url="https://flectone.net/pulse/")
public class FlectonePulseVelocity {
    private static final MinecraftChannelIdentifier IDENTIFIER = MinecraftChannelIdentifier.from((String)"flectonepulse:main");
    private final ProxyServer proxyServer;
    private final FLogger fLogger;

    @Inject
    public FlectonePulseVelocity(ProxyServer proxyServer, Logger logger) {
        this.proxyServer = proxyServer;
        this.fLogger = new FLogger(logRecord -> logger.info(logRecord.getMessage()));
    }

    @Subscribe
    public void onProxyInitializeEvent(ProxyInitializeEvent event) {
        this.fLogger.logEnabling();
        this.proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{IDENTIFIER});
        this.fLogger.logDescription();
        this.fLogger.logEnabled();
    }

    @Subscribe
    public void onPluginMessageEvent(PluginMessageEvent event) {
        if (!event.getIdentifier().equals((Object)IDENTIFIER)) {
            return;
        }
        byte[] data = ProxyMessageProcessor.create(event.getData());
        if (data == null) {
            return;
        }
        this.proxyServer.getAllServers().stream().filter(registeredServer -> !registeredServer.getPlayersConnected().isEmpty()).forEach(serverInfo -> serverInfo.sendPluginMessage((ChannelIdentifier)IDENTIFIER, data));
    }

    @Subscribe
    public void onProxyShutdownEvent(ProxyShutdownEvent event) {
        this.fLogger.logDisabling();
        this.proxyServer.getChannelRegistrar().unregister(new ChannelIdentifier[]{IDENTIFIER});
        this.fLogger.logDisabled();
    }

    @Subscribe
    public void onServerConnectedEvent(ServerConnectedEvent event) {
        byte[] data = ProxyMessageProcessor.create(MessageType.SYSTEM_ONLINE, event.getPlayer().getUniqueId());
        this.proxyServer.getAllServers().stream().filter(registeredServer -> !registeredServer.getPlayersConnected().isEmpty()).forEach(serverInfo -> serverInfo.sendPluginMessage((ChannelIdentifier)IDENTIFIER, data));
    }

    @Subscribe
    public void onDisconnectEvent(DisconnectEvent event) {
        byte[] data = ProxyMessageProcessor.create(MessageType.SYSTEM_OFFLINE, event.getPlayer().getUniqueId());
        this.proxyServer.getAllServers().stream().filter(registeredServer -> !registeredServer.getPlayersConnected().isEmpty()).forEach(serverInfo -> serverInfo.sendPluginMessage((ChannelIdentifier)IDENTIFIER, data));
    }

    public void reload() {
        this.fLogger.logReloading();
        this.proxyServer.getChannelRegistrar().unregister(new ChannelIdentifier[]{IDENTIFIER});
        this.proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{IDENTIFIER});
        this.fLogger.logReloaded();
    }
}

