/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse;

import com.google.gson.Gson;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.flectone.pulse.FlectonePulseAPI;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.annotation.Sync;
import net.flectone.pulse.config.localization.EnglishLocale;
import net.flectone.pulse.config.localization.RussianLocale;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.minimessage.MiniMessage;
import net.flectone.pulse.library.adventure.text.minimessage.tag.resolver.TagResolver;
import net.flectone.pulse.library.adventure.text.object.PlayerHeadObjectContents;
import net.flectone.pulse.library.adventure.text.serializer.gson.GsonComponentSerializer;
import net.flectone.pulse.library.cloud.cloud.type.tuple.Pair;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.AbstractModule;
import net.flectone.pulse.library.guice.Provider;
import net.flectone.pulse.library.guice.Provides;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.matcher.Matchers;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.library.guice.name.Names;
import net.flectone.pulse.library.jackson.annotation.JsonInclude;
import net.flectone.pulse.library.jackson.annotation.JsonSetter;
import net.flectone.pulse.library.jackson.annotation.Nulls;
import net.flectone.pulse.library.jackson.core.JsonParser;
import net.flectone.pulse.library.jackson.core.JsonToken;
import net.flectone.pulse.library.jackson.databind.DeserializationContext;
import net.flectone.pulse.library.jackson.databind.DeserializationFeature;
import net.flectone.pulse.library.jackson.databind.JacksonModule;
import net.flectone.pulse.library.jackson.databind.MapperFeature;
import net.flectone.pulse.library.jackson.databind.ObjectMapper;
import net.flectone.pulse.library.jackson.databind.PropertyNamingStrategies;
import net.flectone.pulse.library.jackson.databind.SerializationFeature;
import net.flectone.pulse.library.jackson.databind.ValueDeserializer;
import net.flectone.pulse.library.jackson.databind.cfg.DatatypeFeature;
import net.flectone.pulse.library.jackson.databind.cfg.EnumFeature;
import net.flectone.pulse.library.jackson.databind.module.SimpleModule;
import net.flectone.pulse.library.jackson.dataformat.yaml.YAMLFactory;
import net.flectone.pulse.library.jackson.dataformat.yaml.YAMLMapper;
import net.flectone.pulse.library.jackson.dataformat.yaml.YAMLWriteFeature;
import net.flectone.pulse.library.packetevents.PacketEvents;
import net.flectone.pulse.library.packetevents.manager.server.ServerVersion;
import net.flectone.pulse.library.snakeyaml.v2.api.LoadSettings;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.util.Cooldown;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.model.util.Ticker;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.registry.CacheRegistry;
import net.flectone.pulse.processing.processor.YamlFileProcessor;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;
import net.flectone.pulse.processing.resolver.SystemVariableResolver;
import net.flectone.pulse.util.creator.BackupCreator;
import net.flectone.pulse.util.interceptor.AsyncInterceptor;
import net.flectone.pulse.util.interceptor.SyncInterceptor;
import net.flectone.pulse.util.logging.FLogger;
import org.aopalliance.intercept.MethodInterceptor;

public abstract class PlatformInjector
extends AbstractModule {
    private final Path projectPath;
    private final LibraryResolver libraryResolver;
    private final FLogger fLogger;

    public PlatformInjector(Path projectPath, LibraryResolver libraryResolver, FLogger fLogger) {
        this.projectPath = projectPath;
        this.libraryResolver = libraryResolver;
        this.fLogger = fLogger;
    }

    protected void configure() {
        this.bind(FLogger.class).toInstance((Object)this.fLogger);
        this.bind(FlectonePulseAPI.class).asEagerSingleton();
        this.bind(LibraryResolver.class).toInstance((Object)this.libraryResolver);
        this.bind(Gson.class).toInstance((Object)GsonComponentSerializer.gson().serializer());
        this.bind(MiniMessage.class).toInstance((Object)MiniMessage.builder().tags(TagResolver.builder().build()).build());
        ReflectionResolver reflectionResolver = new ReflectionResolver(this.libraryResolver);
        this.bind(ReflectionResolver.class).toInstance((Object)reflectionResolver);
        this.setupPaths();
        this.setupBooleans();
        this.setupConfigurations();
        this.setupPlatform(reflectionResolver);
        this.setupInterceptors();
    }

    public abstract void setupPlatform(ReflectionResolver var1);

    private void setupPaths() {
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"projectPath")).toInstance((Object)this.projectPath);
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"imagePath")).toInstance((Object)this.projectPath.resolve("images"));
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"backupPath")).toInstance((Object)this.projectPath.resolve("backups"));
        this.bind(Path.class).annotatedWith((Annotation)Names.named((String)"translationPath")).toInstance((Object)this.projectPath.resolve("localizations/minecraft"));
    }

    private void setupBooleans() {
        ServerVersion serverVersion = PacketEvents.getAPI().getServerManager().getVersion();
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"isNewerThanOrEqualsV_1_14")).toInstance((Object)serverVersion.isNewerThanOrEquals(ServerVersion.V_1_14));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"isNewerThanOrEqualsV_1_21_6")).toInstance((Object)serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_6));
        this.bind(Boolean.class).annotatedWith((Annotation)Names.named((String)"isNewerThanOrEqualsV_1_21_9")).toInstance((Object)serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_9));
    }

    private void setupConfigurations() throws IOException {
        ObjectMapper mapper = this.createMapper();
        this.bind(ObjectMapper.class).toInstance((Object)mapper);
        EnglishLocale englishLocale = new EnglishLocale();
        this.bind(EnglishLocale.class).toInstance((Object)englishLocale);
        RussianLocale russianLocale = new RussianLocale();
        this.bind(RussianLocale.class).toInstance((Object)russianLocale);
        YamlFileProcessor yamlFileProcessor = new YamlFileProcessor(mapper, englishLocale, russianLocale);
        this.bind(YamlFileProcessor.class).toInstance((Object)yamlFileProcessor);
        SystemVariableResolver systemVariableResolver = new SystemVariableResolver();
        this.bind(SystemVariableResolver.class).toInstance((Object)systemVariableResolver);
        BackupCreator backupCreator = new BackupCreator(systemVariableResolver, this.projectPath, this.projectPath.resolve("backups"), this.fLogger);
        this.bind(BackupCreator.class).toInstance((Object)backupCreator);
        FileResolver fileResolver = new FileResolver(this.projectPath, this.fLogger, yamlFileProcessor, backupCreator);
        this.bind(FileResolver.class).toInstance((Object)fileResolver);
        fileResolver.reload();
        CacheRegistry cacheRegistry = new CacheRegistry(fileResolver);
        this.bind(CacheRegistry.class).toInstance((Object)cacheRegistry);
        cacheRegistry.init();
    }

    @Provides
    @Singleton
    @Named(value="offlinePlayers")
    public Cache<UUID, FPlayer> provideOfflinePlayersCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getOfflinePlayersCache();
    }

    @Provides
    @Singleton
    @Named(value="profileProperty")
    public Cache<UUID, PlayerHeadObjectContents.ProfileProperty> provideProfilePropertyCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getProfilePropertyCache();
    }

    @Provides
    @Singleton
    @Named(value="dialogClick")
    public Cache<UUID, AtomicInteger> provideDialogClickCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getDialogClickCache();
    }

    @Provides
    @Singleton
    @Named(value="moderation")
    public Cache<Pair<UUID, Moderation.Type>, List<Moderation>> provideModerationCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getModerationCache();
    }

    @Provides
    @Singleton
    @Named(value="legacyColorMessage")
    public Cache<String, String> provideLegacyColorMessageCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getLegacyColorMessageCache();
    }

    @Provides
    @Singleton
    @Named(value="mentionMessage")
    public Cache<String, String> provideMentionMessageCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getMentionMessageCache();
    }

    @Provides
    @Singleton
    @Named(value="swearMessage")
    public Cache<String, String> provideSwearMessageCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getSwearMessageCache();
    }

    @Provides
    @Singleton
    @Named(value="replacementMessage")
    public Cache<String, String> provideReplacementMessageCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getReplacementMessageCache();
    }

    @Provides
    @Singleton
    @Named(value="replacementImage")
    public Cache<String, Component> provideReplacementImageCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getReplacementImageCache();
    }

    @Provides
    @Singleton
    @Named(value="translateMessage")
    public Cache<String, UUID> provideTranslateMessageCache(CacheRegistry cacheRegistry) {
        return cacheRegistry.getTranslateMessageCache();
    }

    private void setupInterceptors() {
        Provider taskSchedulerProvider = this.getProvider(TaskScheduler.class);
        Provider platformServerAdapterProvider = this.getProvider(PlatformServerAdapter.class);
        AsyncInterceptor asyncInterceptor = new AsyncInterceptor((Provider<TaskScheduler>)taskSchedulerProvider, (Provider<PlatformServerAdapter>)platformServerAdapterProvider, this.fLogger);
        this.bind(AsyncInterceptor.class).toInstance((Object)asyncInterceptor);
        SyncInterceptor syncInterceptor = new SyncInterceptor((Provider<TaskScheduler>)taskSchedulerProvider, (Provider<PlatformServerAdapter>)platformServerAdapterProvider, this.fLogger);
        this.bind(SyncInterceptor.class).toInstance((Object)syncInterceptor);
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Sync.class).or(Matchers.annotatedWith(Async.class)), new MethodInterceptor[]{asyncInterceptor, syncInterceptor});
    }

    private ObjectMapper createMapper() {
        return ((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)YAMLMapper.builder((YAMLFactory)YAMLFactory.builder().loadSettings(LoadSettings.builder().setBufferSize(Integer.valueOf(8192)).setAllowDuplicateKeys(true).build()).build()).disable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY})).disable(new MapperFeature[]{MapperFeature.DETECT_PARAMETER_NAMES})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new MapperFeature[]{MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_TRAILING_TOKENS})).enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT})).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).disable(new YAMLWriteFeature[]{YAMLWriteFeature.SPLIT_LINES}).disable(new YAMLWriteFeature[]{YAMLWriteFeature.WRITE_DOC_START_MARKER}).disable(new YAMLWriteFeature[]{YAMLWriteFeature.USE_NATIVE_TYPE_ID}).propertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE)).disable(new DatatypeFeature[]{EnumFeature.READ_ENUMS_USING_TO_STRING})).disable(new DatatypeFeature[]{EnumFeature.WRITE_ENUMS_USING_TO_STRING})).changeDefaultPropertyInclusion(config -> JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL))).changeDefaultNullHandling(config -> JsonSetter.Value.forValueNulls((Nulls)Nulls.SKIP))).withConfigOverride(String.class, o -> o.setNullHandling(JsonSetter.Value.forContentNulls((Nulls)Nulls.AS_EMPTY)))).withConfigOverride(Collection.class, o -> o.setNullHandling(JsonSetter.Value.forContentNulls((Nulls)Nulls.AS_EMPTY)))).withConfigOverride(List.class, o -> o.setNullHandling(JsonSetter.Value.forContentNulls((Nulls)Nulls.AS_EMPTY)))).withConfigOverride(Set.class, o -> o.setNullHandling(JsonSetter.Value.forContentNulls((Nulls)Nulls.AS_EMPTY)))).withConfigOverride(Map.class, o -> o.setNullHandling(JsonSetter.Value.forContentNulls((Nulls)Nulls.AS_EMPTY)))).defaultMergeable(Boolean.valueOf(true))).withConfigOverride(Destination.class, o -> o.setMergeable(Boolean.valueOf(false)))).withConfigOverride(Sound.class, o -> o.setMergeable(Boolean.valueOf(false)))).withConfigOverride(Range.class, o -> o.setMergeable(Boolean.valueOf(false)))).withConfigOverride(Ticker.class, o -> o.setMergeable(Boolean.valueOf(false)))).withConfigOverride(Cooldown.class, o -> o.setMergeable(Boolean.valueOf(false)))).addModule((JacksonModule)new SimpleModule().addDeserializer(String.class, (ValueDeserializer)new ValueDeserializer<String>(this){

            public String deserialize(JsonParser p, DeserializationContext ctxt) {
                return p.currentToken() == JsonToken.VALUE_NULL ? "" : p.getString();
            }

            public String getNullValue(DeserializationContext ctxt) {
                return "";
            }
        }))).build();
    }
}

