/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.dao;

import java.util.function.Consumer;
import java.util.function.Function;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.data.database.sql.SQL;
import net.flectone.pulse.library.jdbi3.v3.core.Handle;

public abstract class BaseDAO<S extends SQL> {
    public abstract Database database();

    public abstract Class<S> sqlClass();

    public S getSQL(Handle handle) {
        return (S)((SQL)handle.attach(this.sqlClass()));
    }

    protected void useTransaction(Consumer<S> action) {
        this.database().getJdbi().useTransaction(handle -> action.accept(this.getSQL(handle)));
    }

    protected <R> R inTransaction(Function<S, R> action) {
        return (R)this.database().getJdbi().inTransaction(handle -> action.apply(this.getSQL(handle)));
    }

    protected void useHandle(Consumer<S> action) {
        this.database().getJdbi().useHandle(handle -> action.accept(this.getSQL(handle)));
    }

    protected <R> R withHandle(Function<S, R> action) {
        return (R)this.database().getJdbi().withHandle(handle -> action.apply(this.getSQL(handle)));
    }
}

