/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.database.dao;

import lombok.Generated;
import net.flectone.pulse.data.database.Database;
import net.flectone.pulse.data.database.dao.BaseDAO;
import net.flectone.pulse.data.database.sql.SettingSQL;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.util.constant.SettingText;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class SettingDAO
extends BaseDAO<SettingSQL> {
    private final Database database;
    private final FLogger fLogger;

    @Override
    public Database database() {
        return this.database;
    }

    @Override
    public Class<SettingSQL> sqlClass() {
        return SettingSQL.class;
    }

    public void save(FPlayer player) {
        this.useTransaction(sql -> {
            player.getSettingsBoolean().forEach((messageType, value) -> this.insertOrUpdate((SettingSQL)sql, player, (String)messageType, player.getSetting((String)messageType)));
            player.getSettingsText().forEach((settingText, string) -> this.insertOrUpdate((SettingSQL)sql, player, settingText.name(), (String)string));
        });
    }

    private void insertOrUpdate(SettingSQL sql, FPlayer player, String type, String value) {
        int updated = sql.update(player.getId(), type, value);
        if (updated == 0) {
            sql.insert(player.getId(), type, value);
        }
    }

    public void load(FPlayer player) {
        player.getSettingsBoolean().clear();
        player.getSettingsText().clear();
        this.useHandle(sql -> sql.findByPlayer(player.getId()).forEach((string, value) -> {
            SettingText settingText = SettingText.fromString(string);
            if (settingText == null) {
                try {
                    player.setSetting(string.toUpperCase(), value.equals("1"));
                }
                catch (IllegalArgumentException e) {
                    this.fLogger.warning(e);
                }
            } else {
                player.setSetting(settingText, (String)value);
            }
        }));
    }

    public void insertOrUpdate(FPlayer player, String setting) {
        this.useHandle(sql -> this.insertOrUpdate((SettingSQL)sql, player, setting, player.getSetting(setting)));
    }

    public void insertOrUpdate(FPlayer player, SettingText settingText) {
        this.useHandle(sql -> this.insertOrUpdate((SettingSQL)sql, player, settingText.name(), player.getSetting(settingText)));
    }

    @Inject
    @Generated
    public SettingDAO(Database database, FLogger fLogger) {
        this.database = database;
        this.fLogger = fLogger;
    }
}

