/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.data.repository;

import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.flectone.pulse.data.database.dao.ColorsDAO;
import net.flectone.pulse.data.database.dao.FPlayerDAO;
import net.flectone.pulse.data.database.dao.SettingDAO;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.util.constant.SettingText;

@Singleton
public class FPlayerRepository {
    private final Map<UUID, FPlayer> onlinePlayers = new ConcurrentHashMap<UUID, FPlayer>();
    @Named(value="offlinePlayers")
    private final Cache<UUID, FPlayer> offlinePlayersCache;
    private final FPlayerDAO fPlayerDAO;
    private final SettingDAO settingDAO;
    private final ColorsDAO colorsDAO;

    public void invalid(UUID uuid) {
        this.onlinePlayers.remove(uuid);
        this.offlinePlayersCache.invalidate((Object)uuid);
    }

    public FPlayer get(int id) {
        Optional<FPlayer> onlinePlayer = this.onlinePlayers.values().stream().filter(p -> p.getId() == id).findFirst();
        if (onlinePlayer.isPresent()) {
            return onlinePlayer.get();
        }
        Optional<FPlayer> cachedPlayer = this.offlinePlayersCache.asMap().values().stream().filter(p -> p.getId() == id).findFirst();
        if (cachedPlayer.isPresent()) {
            return cachedPlayer.get();
        }
        FPlayer dbPlayer = this.fPlayerDAO.getFPlayer(id);
        this.saveToCache(dbPlayer);
        return dbPlayer;
    }

    public FPlayer get(InetAddress inetAddress) {
        String ip = inetAddress.getHostAddress();
        Optional<FPlayer> onlinePlayer = this.onlinePlayers.values().stream().filter(p -> ip.equals(p.getIp())).findFirst();
        if (onlinePlayer.isPresent()) {
            return onlinePlayer.get();
        }
        Optional<FPlayer> cachedPlayer = this.offlinePlayersCache.asMap().values().stream().filter(p -> ip.equals(p.getIp())).findFirst();
        if (cachedPlayer.isPresent()) {
            return cachedPlayer.get();
        }
        FPlayer dbPlayer = this.fPlayerDAO.getFPlayer(inetAddress);
        this.saveToCache(dbPlayer);
        return dbPlayer;
    }

    public FPlayer get(UUID uuid) {
        FPlayer onlinePlayer = this.onlinePlayers.get(uuid);
        if (onlinePlayer != null) {
            return onlinePlayer;
        }
        FPlayer cachedPlayer = (FPlayer)this.offlinePlayersCache.getIfPresent((Object)uuid);
        if (cachedPlayer != null) {
            return cachedPlayer;
        }
        FPlayer dbPlayer = this.fPlayerDAO.getFPlayer(uuid);
        this.saveToCache(dbPlayer);
        return dbPlayer;
    }

    public FPlayer get(String playerName) {
        Optional<FPlayer> onlinePlayer = this.onlinePlayers.values().stream().filter(p -> p.getName().equalsIgnoreCase(playerName)).findFirst();
        if (onlinePlayer.isPresent()) {
            return onlinePlayer.get();
        }
        Optional<FPlayer> cachedPlayer = this.offlinePlayersCache.asMap().values().stream().filter(p -> p.getName().equalsIgnoreCase(playerName)).findFirst();
        if (cachedPlayer.isPresent()) {
            return cachedPlayer.get();
        }
        FPlayer dbPlayer = this.fPlayerDAO.getFPlayer(playerName);
        this.saveToCache(dbPlayer);
        return dbPlayer;
    }

    private void saveToCache(FPlayer fPlayer) {
        if (fPlayer.isOnline()) {
            this.onlinePlayers.put(fPlayer.getUuid(), fPlayer);
        } else {
            this.offlinePlayersCache.put((Object)fPlayer.getUuid(), (Object)fPlayer);
        }
    }

    public boolean save(UUID uuid, String name) {
        return this.fPlayerDAO.insert(uuid, name);
    }

    public void update(FPlayer fPlayer) {
        this.fPlayerDAO.update(fPlayer);
    }

    public void saveOrIgnore(FPlayer fPlayer) {
        this.fPlayerDAO.insertOrIgnore(fPlayer);
    }

    public void removeOffline(UUID uuid) {
        this.offlinePlayersCache.invalidate((Object)uuid);
    }

    public void removeOnline(UUID uuid) {
        FPlayer fPlayer = this.onlinePlayers.get(uuid);
        if (fPlayer != null) {
            fPlayer.setOnline(false);
            this.offlinePlayersCache.put((Object)uuid, (Object)fPlayer);
        }
        this.onlinePlayers.remove(uuid);
    }

    public void add(FPlayer fPlayer) {
        this.onlinePlayers.put(fPlayer.getUuid(), fPlayer);
        this.offlinePlayersCache.invalidate((Object)fPlayer.getUuid());
    }

    public List<FPlayer> getAllPlayersDatabase() {
        return this.fPlayerDAO.getFPlayers();
    }

    public List<FPlayer> getOnlinePlayersDatabase() {
        return this.fPlayerDAO.getOnlineFPlayers();
    }

    public List<FPlayer> getOnlinePlayers() {
        return this.onlinePlayers.values().stream().filter(FPlayer::isOnline).toList();
    }

    public List<FPlayer> getOnlineFPlayersWithConsole() {
        return this.onlinePlayers.values().stream().filter(fPlayer -> fPlayer.isOnline() || fPlayer.isConsole()).toList();
    }

    public void clearCache() {
        this.onlinePlayers.clear();
        this.offlinePlayersCache.invalidateAll();
    }

    public void loadColors(FPlayer fPlayer) {
        this.colorsDAO.load(fPlayer);
    }

    public void saveColors(FPlayer fPlayer) {
        this.colorsDAO.save(fPlayer);
    }

    public void saveSettings(FPlayer fPlayer) {
        this.settingDAO.save(fPlayer);
    }

    public void loadSettings(FPlayer fPlayer) {
        this.settingDAO.load(fPlayer);
    }

    public void saveOrUpdateSetting(FPlayer fPlayer, String setting) {
        this.settingDAO.insertOrUpdate(fPlayer, setting);
    }

    public void saveOrUpdateSetting(FPlayer fPlayer, SettingText setting) {
        this.settingDAO.insertOrUpdate(fPlayer, setting);
    }

    @Inject
    @Generated
    public FPlayerRepository(@Named(value="offlinePlayers") Cache<UUID, FPlayer> offlinePlayersCache, FPlayerDAO fPlayerDAO, SettingDAO settingDAO, ColorsDAO colorsDAO) {
        this.offlinePlayersCache = offlinePlayersCache;
        this.fPlayerDAO = fPlayerDAO;
        this.settingDAO = settingDAO;
        this.colorsDAO = colorsDAO;
    }
}

