/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.execution.scheduler;

import lombok.Generated;
import net.flectone.pulse.execution.scheduler.SchedulerRunnable;
import net.flectone.pulse.execution.scheduler.TaskScheduler;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;

@Singleton
public class BukkitTaskScheduler
implements TaskScheduler {
    private final Plugin plugin;
    private final net.flectone.pulse.library.universalscheduler.universalScheduler.scheduling.schedulers.TaskScheduler taskScheduler;
    private final FLogger fLogger;
    private volatile boolean disabled = false;

    @Override
    public void shutdown() {
        this.disabled = true;
        this.taskScheduler.cancelTasks(this.plugin);
    }

    @Override
    public void reload() {
        this.shutdown();
        this.disabled = false;
    }

    @Override
    public void runAsync(SchedulerRunnable runnable) {
        if (this.disabled) {
            return;
        }
        this.taskScheduler.runTaskAsynchronously(() -> {
            try {
                runnable.run();
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
            }
            catch (Exception e) {
                this.fLogger.warning(e);
            }
        });
    }

    @Override
    public void runAsyncTimer(SchedulerRunnable runnable, long tick, long period) {
        if (this.disabled) {
            return;
        }
        this.taskScheduler.runTaskTimerAsynchronously(() -> {
            try {
                runnable.run();
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
            }
            catch (Exception e) {
                this.fLogger.warning(e);
            }
        }, tick, period);
    }

    @Override
    public void runAsyncTimer(SchedulerRunnable runnable, long tick) {
        this.runAsyncTimer(runnable, tick, tick);
    }

    @Override
    public void runAsyncLater(SchedulerRunnable runnable, long tick) {
        if (this.disabled) {
            return;
        }
        this.taskScheduler.runTaskLaterAsynchronously(() -> {
            try {
                runnable.run();
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
            }
            catch (Exception e) {
                this.fLogger.warning(e);
            }
        }, tick);
    }

    @Override
    public void runSync(SchedulerRunnable runnable) {
        if (this.disabled) {
            return;
        }
        this.taskScheduler.runTask(() -> {
            try {
                runnable.run();
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
            }
            catch (Exception e) {
                this.fLogger.warning(e);
            }
        });
    }

    @Override
    public void runSyncRegion(Object entity, SchedulerRunnable runnable) {
        if (this.disabled) {
            return;
        }
        if (!(entity instanceof Entity)) {
            this.runSync(runnable);
            return;
        }
        Entity bukkitEntity = (Entity)entity;
        this.taskScheduler.runTask(bukkitEntity.getLocation(), () -> {
            try {
                runnable.run();
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
            }
            catch (Exception e) {
                this.fLogger.warning(e);
            }
        });
    }

    @Override
    public void runSyncTimer(SchedulerRunnable runnable, long tick, long period) {
        if (this.disabled) {
            return;
        }
        this.taskScheduler.runTaskTimer(() -> {
            try {
                runnable.run();
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
            }
            catch (Exception e) {
                this.fLogger.warning(e);
            }
        }, tick, period);
    }

    @Override
    public void runSyncTimer(SchedulerRunnable runnable, long tick) {
        this.runSyncTimer(runnable, tick, tick);
    }

    @Override
    public void runSyncLater(SchedulerRunnable runnable, long tick) {
        if (this.disabled) {
            return;
        }
        this.taskScheduler.runTaskLater(() -> {
            try {
                runnable.run();
            }
            catch (IllegalPluginAccessException illegalPluginAccessException) {
            }
            catch (Exception e) {
                this.fLogger.warning(e);
            }
        }, tick);
    }

    @Inject
    @Generated
    public BukkitTaskScheduler(Plugin plugin, net.flectone.pulse.library.universalscheduler.universalScheduler.scheduling.schedulers.TaskScheduler taskScheduler, FLogger fLogger) {
        this.plugin = plugin;
        this.taskScheduler = taskScheduler;
        this.fLogger = fLogger;
    }
}

