/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.listener;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.flectone.pulse.library.guava.cache.Cache;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.library.packetevents.event.PacketListener;
import net.flectone.pulse.library.packetevents.event.PacketReceiveEvent;
import net.flectone.pulse.library.packetevents.protocol.packettype.PacketType;
import net.flectone.pulse.library.packetevents.protocol.player.User;
import net.flectone.pulse.library.packetevents.wrapper.play.client.WrapperPlayClientCustomClickAction;
import net.flectone.pulse.platform.controller.DialogController;

@Singleton
public class DialogPacketListener
implements PacketListener {
    @Named(value="dialogClick")
    private final Cache<UUID, AtomicInteger> dialogClickCache;
    private final DialogController dialogController;

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.getPacketType() == PacketType.Play.Client.CUSTOM_CLICK_ACTION) {
            User user = event.getUser();
            if (this.isSpam(user.getUUID())) {
                return;
            }
            WrapperPlayClientCustomClickAction wrapper = new WrapperPlayClientCustomClickAction(event);
            String key = wrapper.getId().getKey();
            this.dialogController.process(user.getUUID(), key, wrapper.getPayload());
        }
    }

    public boolean isSpam(UUID uuid) {
        int current;
        AtomicInteger count = (AtomicInteger)this.dialogClickCache.getIfPresent((Object)uuid);
        if (count == null) {
            count = new AtomicInteger(0);
            this.dialogClickCache.put((Object)uuid, (Object)count);
        }
        return (current = count.incrementAndGet()) > 5;
    }

    @Inject
    @Generated
    public DialogPacketListener(@Named(value="dialogClick") Cache<UUID, AtomicInteger> dialogClickCache, DialogController dialogController) {
        this.dialogClickCache = dialogClickCache;
        this.dialogController = dialogController;
    }
}

