/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.listener;

import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.platform.adapter.PlatformPlayerAdapter;
import net.flectone.pulse.platform.sender.MessageSender;

@Singleton
public class MessagePulseListener
implements PulseListener {
    private final MessageSender messageSender;
    private final PlatformPlayerAdapter platformPlayerAdapter;

    @Pulse(priority=Event.Priority.HIGHEST)
    public void onSenderToReceiverMessageEvent(MessageSendEvent event) {
        Component message = event.getMessage();
        if (!Component.IS_NOT_EMPTY.test(message)) {
            return;
        }
        FPlayer fReceiver = event.getReceiver();
        if (fReceiver.isConsole()) {
            this.messageSender.sendToConsole(message);
            return;
        }
        Component submessage = event.getSubmessage();
        Destination destination = event.getEventMetadata().getDestination();
        switch (destination.getType()) {
            case TITLE: {
                this.messageSender.sendTitle(fReceiver, message, submessage, destination.getTimes());
                break;
            }
            case SUBTITLE: {
                this.messageSender.sendTitle(fReceiver, submessage, message, destination.getTimes());
                break;
            }
            case ACTION_BAR: {
                this.messageSender.sendActionBar(fReceiver, message, destination.getTimes().stayTicks());
                break;
            }
            case BOSS_BAR: {
                this.messageSender.sendBoosBar(fReceiver, message, destination.getBossBar());
                break;
            }
            case TAB_HEADER: {
                this.messageSender.sendPlayerListHeaderAndFooter(fReceiver, message, this.platformPlayerAdapter.getPlayerListFooter(fReceiver));
                break;
            }
            case TAB_FOOTER: {
                this.messageSender.sendPlayerListHeaderAndFooter(fReceiver, this.platformPlayerAdapter.getPlayerListHeader(fReceiver), message);
                break;
            }
            case TOAST: {
                this.messageSender.sendToast(fReceiver, message, destination.getToast());
                break;
            }
            case BRAND: {
                this.messageSender.sendBrand(fReceiver, message);
                break;
            }
            default: {
                this.messageSender.sendMessage(fReceiver, message, false);
            }
        }
    }

    @Inject
    @Generated
    public MessagePulseListener(MessageSender messageSender, PlatformPlayerAdapter platformPlayerAdapter) {
        this.messageSender = messageSender;
        this.platformPlayerAdapter = platformPlayerAdapter;
    }
}

