/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.dialog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.Generated;
import net.flectone.pulse.library.packetevents.protocol.dialog.CommonDialogData;
import net.flectone.pulse.library.packetevents.protocol.dialog.MultiActionDialog;
import net.flectone.pulse.library.packetevents.protocol.dialog.button.ActionButton;
import net.flectone.pulse.library.packetevents.protocol.nbt.NBT;
import net.flectone.pulse.library.packetevents.wrapper.play.server.WrapperPlayServerShowDialog;

public class Dialog {
    private final Map<String, BiConsumer<Dialog, NBT>> clickConsumerMap = new HashMap<String, BiConsumer<Dialog, NBT>>();
    private final List<Consumer<Dialog>> closeConsumerList = new ArrayList<Consumer<Dialog>>();
    private WrapperPlayServerShowDialog wrapperDialog;

    public Dialog(Map<String, BiConsumer<Dialog, NBT>> clickConsumerMap, List<Consumer<Dialog>> closeConsumerList, WrapperPlayServerShowDialog wrapperDialog) {
        this.clickConsumerMap.putAll(clickConsumerMap);
        this.closeConsumerList.addAll(closeConsumerList);
        this.wrapperDialog = wrapperDialog;
    }

    @Generated
    public Map<String, BiConsumer<Dialog, NBT>> getClickConsumerMap() {
        return this.clickConsumerMap;
    }

    @Generated
    public List<Consumer<Dialog>> getCloseConsumerList() {
        return this.closeConsumerList;
    }

    @Generated
    public WrapperPlayServerShowDialog getWrapperDialog() {
        return this.wrapperDialog;
    }

    @Generated
    public void setWrapperDialog(WrapperPlayServerShowDialog wrapperDialog) {
        this.wrapperDialog = wrapperDialog;
    }

    public static class Builder {
        private final CommonDialogData commonDialogData;
        private final int columns;
        private final Map<Integer, ActionButton> buttonMap = new HashMap<Integer, ActionButton>();
        private final Map<String, BiConsumer<Dialog, NBT>> clickConsumerMap = new HashMap<String, BiConsumer<Dialog, NBT>>();
        private final List<Consumer<Dialog>> closeConsumerList = new ArrayList<Consumer<Dialog>>();

        public Builder(CommonDialogData commonDialogData, int columns) {
            this.commonDialogData = commonDialogData;
            this.columns = columns;
        }

        public Builder addButton(int slot, ActionButton actionButton) {
            this.buttonMap.put(slot, actionButton);
            return this;
        }

        public Builder addClickHandler(String id, Consumer<Dialog> consumer) {
            this.clickConsumerMap.put(id, (dialog, nbt) -> consumer.accept((Dialog)dialog));
            return this;
        }

        public Builder addClickHandler(String id, BiConsumer<Dialog, NBT> consumer) {
            this.clickConsumerMap.put(id, consumer);
            return this;
        }

        public Builder addCloseConsumer(Consumer<Dialog> consumer) {
            this.closeConsumerList.add(consumer);
            return this;
        }

        public Dialog build() {
            List<ActionButton> buttons = this.buttonMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).toList();
            MultiActionDialog multiActionDialog = new MultiActionDialog(this.commonDialogData, buttons, null, this.columns);
            WrapperPlayServerShowDialog wrapperPlayServerShowDialog = new WrapperPlayServerShowDialog((net.flectone.pulse.library.packetevents.protocol.dialog.Dialog)multiActionDialog);
            return new Dialog(this.clickConsumerMap, this.closeConsumerList, wrapperPlayServerShowDialog);
        }
    }
}

