/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.command.ignore.model.Ignore;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FPlayer
extends FEntity {
    public static final FPlayer UNKNOWN = new FPlayer("UNKNOWN_FLECTONEPULSE");
    public static final String TYPE = "PLAYER";
    private final int id;
    private final boolean console;
    private final Map<FColor.Type, Set<FColor>> fColors = new EnumMap<FColor.Type, Set<FColor>>(FColor.Type.class);
    private final Map<String, Boolean> settingsBoolean = new HashMap<String, Boolean>();
    private final Map<SettingText, String> settingsText = new EnumMap<SettingText, String>(SettingText.class);
    private final List<Ignore> ignores = new ArrayList<Ignore>();
    private boolean online;
    private String ip;
    private String constantName;

    public FPlayer(int id, boolean console, String name, UUID uuid, String type) {
        super(name, uuid, type);
        this.id = id;
        this.console = console;
    }

    public FPlayer(int id, String name, UUID uuid, String type) {
        this(id, false, name, uuid, type);
    }

    public FPlayer(int id, String name, UUID uuid) {
        this(id, name, uuid, TYPE);
    }

    public FPlayer(String name, UUID uuid, String type) {
        this(-1, false, name, uuid, type);
    }

    public FPlayer(boolean console, String name) {
        this(-1, console, name, FEntity.UNKNOWN_UUID, "UNKNOWN");
    }

    public FPlayer(String name) {
        this(-1, false, name, FEntity.UNKNOWN_UUID, "UNKNOWN");
    }

    @Override
    public boolean isUnknown() {
        return this.getId() == -1;
    }

    public void setOnline(boolean online) {
        if (this.isUnknown()) {
            return;
        }
        this.online = online;
    }

    public void setIp(String ip) {
        if (this.isUnknown()) {
            return;
        }
        this.ip = ip;
    }

    public void setConstantName(String constantName) {
        if (this.isUnknown()) {
            return;
        }
        this.constantName = constantName;
    }

    public boolean isIgnored(@NotNull FPlayer fPlayer) {
        if (this.ignores.isEmpty()) {
            return false;
        }
        return this.ignores.stream().anyMatch(ignore -> ignore.target() == fPlayer.getId());
    }

    public void setSetting(String messageType, boolean value) {
        this.settingsBoolean.put(messageType, value);
    }

    public void setSetting(SettingText settingText, String value) {
        this.settingsText.put(settingText, value);
    }

    @Nullable
    public String getSetting(SettingText settingText) {
        return this.settingsText.get((Object)settingText);
    }

    @NotNull
    public String getSetting(MessageType messageType) {
        return this.getSetting(messageType.name());
    }

    @NotNull
    public String getSetting(String messageType) {
        return this.isSetting(messageType) ? "1" : "0";
    }

    public boolean isSetting(MessageType messageType) {
        return this.isSetting(messageType.name());
    }

    public boolean isSetting(String messageType) {
        Boolean value = this.settingsBoolean.get(messageType);
        return value == null || value != false;
    }

    public void removeSetting(SettingText settingText) {
        this.settingsText.remove((Object)settingText);
    }

    public void removeSetting(String messageType) {
        this.settingsBoolean.remove(messageType);
    }

    public void removeSetting(MessageType messageType) {
        this.removeSetting(messageType.name());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FPlayer fPlayer = (FPlayer)object;
        return this.id == fPlayer.getId();
    }

    public Map<Integer, String> getFColors(FColor.Type type) {
        return this.fColors.getOrDefault((Object)type, Collections.emptySet()).stream().collect(Collectors.toMap(FColor::number, FColor::name));
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public boolean isConsole() {
        return this.console;
    }

    @Generated
    public Map<FColor.Type, Set<FColor>> getFColors() {
        return this.fColors;
    }

    @Generated
    public Map<String, Boolean> getSettingsBoolean() {
        return this.settingsBoolean;
    }

    @Generated
    public Map<SettingText, String> getSettingsText() {
        return this.settingsText;
    }

    @Generated
    public List<Ignore> getIgnores() {
        return this.ignores;
    }

    @Generated
    public boolean isOnline() {
        return this.online;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getConstantName() {
        return this.constantName;
    }
}

