/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.model.util;

import lombok.Generated;
import net.flectone.pulse.library.jdbi3.v3.core.mapper.reflect.ColumnName;
import net.flectone.pulse.library.jdbi3.v3.core.mapper.reflect.JdbiConstructor;

public class Moderation {
    public static final int PERMANENT_TIME = -1;
    private final int id;
    private final int player;
    private final long date;
    private final long time;
    private final String reason;
    private final int moderator;
    private final Type type;
    private boolean valid;

    @JdbiConstructor
    public Moderation(@ColumnName(value="id") int id, @ColumnName(value="player") int player, @ColumnName(value="date") long date, @ColumnName(value="time") long time, @ColumnName(value="reason") String reason, @ColumnName(value="moderator") int moderator, @ColumnName(value="type") int typeOrdinal, @ColumnName(value="valid") boolean valid) {
        this.id = id;
        this.player = player;
        this.date = date;
        this.time = time;
        this.reason = reason;
        this.moderator = moderator;
        this.type = Type.values()[typeOrdinal];
        this.valid = valid;
    }

    public Moderation(int id, int player, long date, long time, String reason, int moderator, Type type, boolean valid) {
        this.id = id;
        this.player = player;
        this.date = date;
        this.time = time;
        this.reason = reason;
        this.moderator = moderator;
        this.type = type;
        this.valid = valid;
    }

    public boolean isActive() {
        return this.isValid() && !this.isExpired();
    }

    public void setInvalid() {
        this.valid = false;
    }

    public boolean isPermanent() {
        return this.time == -1L;
    }

    public boolean isExpired() {
        if (this.time == -1L) {
            return false;
        }
        return System.currentTimeMillis() > this.time;
    }

    public long getRemainingTime() {
        if (this.time == -1L) {
            return -1L;
        }
        return this.time - System.currentTimeMillis();
    }

    public long getOriginalTime() {
        return (Math.abs(this.date - this.time) + 500L) / 1000L * 1000L;
    }

    public boolean equals(Moderation moderation) {
        return this.id == moderation.getId();
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public int getPlayer() {
        return this.player;
    }

    @Generated
    public long getDate() {
        return this.date;
    }

    @Generated
    public long getTime() {
        return this.time;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public int getModerator() {
        return this.moderator;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    public static enum Type {
        MUTE,
        BAN,
        WARN,
        KICK;

    }
}

