/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import lombok.Generated;
import net.flectone.pulse.config.Config;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.platform.registry.PermissionRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModule {
    private final Set<Class<? extends AbstractModule>> children = new LinkedHashSet<Class<? extends AbstractModule>>();
    private final List<BiPredicate<FEntity, Boolean>> predicates = new ArrayList<BiPredicate<FEntity, Boolean>>();
    @Inject
    private PermissionRegistry permissionRegistry;
    @Nullable
    private String permission;
    private boolean enable;

    protected AbstractModule() {
    }

    public void onEnable() {
        Permission.IPermission permission = this.permission();
        this.registerPermission(permission);
        this.permission = permission.getName();
    }

    public void onDisable() {
    }

    public void configureChildren() {
    }

    public abstract Config.IEnable config();

    public abstract Permission.IPermission permission();

    public void registerPermission(Permission.IPermission permission) {
        if (permission == null) {
            return;
        }
        this.registerPermission(permission.getName(), permission.getType());
    }

    public void registerPermission(String name, Permission.Type type) {
        this.permissionRegistry.register(name, type);
    }

    public void addChildren(Class<? extends AbstractModule> clazz) {
        this.children.add(clazz);
    }

    public void addPredicate(Predicate<FEntity> predicate) {
        this.predicates.add((fEntity, value) -> predicate.test((FEntity)fEntity));
    }

    public void addPredicate(BiPredicate<FEntity, Boolean> biPredicate) {
        this.predicates.add(biPredicate);
    }

    public boolean isModuleDisabledFor(FEntity entity) {
        return this.isModuleDisabledFor(entity, false);
    }

    public boolean isModuleDisabledFor(FEntity entity, boolean isMessage) {
        for (BiPredicate<FEntity, Boolean> predicate : this.predicates) {
            if (!predicate.test(entity, isMessage)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public Set<Class<? extends AbstractModule>> getChildren() {
        return this.children;
    }

    @Generated
    public List<BiPredicate<FEntity, Boolean>> getPredicates() {
        return this.predicates;
    }

    @Generated
    public PermissionRegistry getPermissionRegistry() {
        return this.permissionRegistry;
    }

    @Nullable
    @Generated
    public String getPermission() {
        return this.permission;
    }

    @Generated
    public boolean isEnable() {
        return this.enable;
    }

    @Generated
    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

