/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module;

import java.util.HashMap;
import java.util.List;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModuleLocalization;
import net.flectone.pulse.util.RandomUtil;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleListLocalization<M extends Localization.Localizable>
extends AbstractModuleLocalization<M> {
    private final HashMap<Integer, Integer> messageIndexMap = new HashMap();
    @Inject
    private RandomUtil randomUtil;

    public abstract List<String> getAvailableMessages(FPlayer var1);

    public List<String> joinMultiList(List<List<String>> values) {
        return values.stream().map(strings -> String.join((CharSequence)"<br>", strings)).toList();
    }

    @Nullable
    public String getCurrentMessage(FPlayer fPlayer) {
        List<String> messages = this.getAvailableMessages(fPlayer);
        if (messages.isEmpty()) {
            return null;
        }
        int fPlayerID = fPlayer.getId();
        int playerIndex = this.messageIndexMap.getOrDefault(fPlayerID, 0) % messages.size();
        return messages.get(playerIndex);
    }

    @Nullable
    public String getNextMessage(FPlayer fPlayer, boolean random) {
        int id = fPlayer.getId();
        List<String> messages = this.getAvailableMessages(fPlayer);
        return this.incrementAndGetMessage(id, random, messages);
    }

    @Nullable
    public String getNextMessage(FPlayer fPlayer, boolean random, List<String> messages) {
        int id = fPlayer.getId() + messages.hashCode();
        return this.incrementAndGetMessage(id, random, messages);
    }

    @Nullable
    private String incrementAndGetMessage(int id, boolean random, List<String> messages) {
        if (messages.isEmpty()) {
            return null;
        }
        int playerIndex = this.messageIndexMap.getOrDefault(id, 0);
        if (random) {
            playerIndex = this.randomUtil.nextInt(0, messages.size());
        } else {
            ++playerIndex;
            playerIndex %= messages.size();
        }
        this.messageIndexMap.put(id, playerIndex);
        return messages.get(playerIndex);
    }
}

