/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.dispatcher.EventDispatcher;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.adventure.text.TextComponent;
import net.flectone.pulse.library.adventure.text.minimessage.tag.Tag;
import net.flectone.pulse.library.adventure.text.minimessage.tag.TagPattern;
import net.flectone.pulse.library.adventure.text.minimessage.tag.resolver.TagResolver;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.message.MessagePrepareEvent;
import net.flectone.pulse.model.event.message.MessageSendEvent;
import net.flectone.pulse.model.util.Cooldown;
import net.flectone.pulse.model.util.Destination;
import net.flectone.pulse.model.util.Sound;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.platform.filter.RangeFilter;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.constant.MessageType;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleLocalization<M extends Localization.Localizable>
extends AbstractModule {
    @Inject
    private FPlayerService fPlayerService;
    @Inject
    private RangeFilter rangeFilter;
    @Inject
    private MessagePipeline messagePipeline;
    @Inject
    private EventDispatcher eventDispatcher;
    private Cooldown moduleCooldown;
    private Sound moduleSound;

    public abstract MessageType messageType();

    public abstract M localization(FEntity var1);

    public M localization() {
        return this.localization(FPlayer.UNKNOWN);
    }

    public Sound createSound(Sound sound, Permission.IPermission permission) {
        this.moduleSound = sound;
        if (permission != null) {
            this.registerPermission(permission);
            sound.setPermission(permission.getName());
        }
        return sound;
    }

    public Cooldown createCooldown(Cooldown cooldown, Permission.IPermission permission) {
        this.moduleCooldown = cooldown;
        if (permission != null) {
            this.registerPermission(permission);
            cooldown.setPermissionBypass(permission.getName());
        }
        return this.moduleCooldown;
    }

    public EventMetadata.EventMetadataBuilder<M, ?, ?> metadataBuilder() {
        return EventMetadata.builder();
    }

    public List<FPlayer> createReceivers(MessageType messageType, EventMetadata<M> eventMetadata) {
        String rawFormat = eventMetadata.resolveFormat(FPlayer.UNKNOWN, this.localization());
        MessagePrepareEvent messagePrepareEvent = new MessagePrepareEvent(messageType, rawFormat, eventMetadata);
        this.eventDispatcher.dispatch(messagePrepareEvent);
        if (messagePrepareEvent.isCancelled()) {
            return Collections.emptyList();
        }
        FPlayer filterPlayer = eventMetadata.getFilterPlayer();
        return this.fPlayerService.getFPlayersWithConsole().stream().filter(eventMetadata.getFilter()).filter(this.rangeFilter.createFilter(filterPlayer, eventMetadata.getRange())).filter(fReceiver -> fReceiver.isSetting(messageType)).toList();
    }

    public void sendMessage(EventMetadata<M> eventMetadata) {
        this.sendMessage(this.messageType(), eventMetadata);
    }

    public void sendMessage(MessageType messageType, EventMetadata<M> eventMetadata) {
        List<FPlayer> receivers = this.createReceivers(messageType, eventMetadata);
        this.sendMessage(messageType, receivers, eventMetadata);
    }

    public void sendMessage(List<FPlayer> receivers, EventMetadata<M> eventMetadata) {
        this.sendMessage(this.messageType(), receivers, eventMetadata);
    }

    @Async
    public void sendMessage(MessageType messageType, List<FPlayer> receivers, EventMetadata<M> eventMetadata) {
        if (receivers.isEmpty()) {
            return;
        }
        receivers.forEach(receiver -> {
            Component messageComponent = this.buildMessageComponent((FPlayer)receiver, eventMetadata);
            Component formatComponent = this.buildFormatComponent((FPlayer)receiver, eventMetadata, messageComponent);
            TextComponent subComponent = Component.empty();
            Destination destination = eventMetadata.getDestination();
            if (destination.getType() == Destination.Type.TITLE || destination.getType() == Destination.Type.SUBTITLE) {
                subComponent = this.buildSubcomponent((FPlayer)receiver, eventMetadata, messageComponent);
            }
            this.eventDispatcher.dispatch(new MessageSendEvent(messageType, (FPlayer)receiver, formatComponent, (Component)subComponent, eventMetadata));
        });
    }

    public void sendErrorMessage(EventMetadata<M> eventMetadata) {
        this.sendMessage(MessageType.ERROR, eventMetadata);
    }

    private Component buildSubcomponent(FPlayer receiver, EventMetadata<M> eventMetadata, Component message) {
        Destination destination = eventMetadata.getDestination();
        return destination.getSubtext().isEmpty() ? Component.empty() : this.messagePipeline.builder(eventMetadata.getSender(), receiver, destination.getSubtext()).flag(MessageFlag.SENDER_COLOR_OUT, eventMetadata.isSenderColorOut()).tagResolvers(this.messageTag(message)).build();
    }

    private Component buildMessageComponent(FPlayer receiver, EventMetadata<M> eventMetadata) {
        String message = eventMetadata.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            return Component.empty();
        }
        FEntity sender = eventMetadata.getSender();
        boolean senderColorOut = eventMetadata.isSenderColorOut();
        MessagePipeline.Builder messageBuilder = this.messagePipeline.builder(sender, receiver, message).flag(MessageFlag.USER_MESSAGE, true).flag(MessageFlag.SENDER_COLOR_OUT, senderColorOut).flag(MessageFlag.MENTION, !receiver.isUnknown());
        return messageBuilder.build();
    }

    private Component buildFormatComponent(FPlayer receiver, EventMetadata<M> eventMetadata, Component message) {
        String formatContent = eventMetadata.resolveFormat(receiver, this.localization(receiver));
        if (StringUtils.isEmpty((CharSequence)formatContent)) {
            return Component.empty();
        }
        FEntity sender = eventMetadata.getSender();
        boolean senderColorOut = eventMetadata.isSenderColorOut();
        MessagePipeline.Builder formatBuilder = this.messagePipeline.builder(eventMetadata.getUuid(), sender, receiver, formatContent).flag(MessageFlag.SENDER_COLOR_OUT, senderColorOut).tagResolvers(eventMetadata.getTagResolvers(receiver)).tagResolvers(this.messageTag(message));
        if (!receiver.isUnknown()) {
            formatBuilder = formatBuilder.setUserMessage(eventMetadata.getMessage()).translate(formatContent.contains("<translate"));
        }
        return formatBuilder.build();
    }

    public TagResolver messageTag(Component message) {
        return TagResolver.resolver((String)"message", (argumentQueue, context) -> Tag.inserting((Component)message));
    }

    public TagResolver targetTag(@TagPattern String tag, FPlayer receiver, @Nullable FEntity target) {
        if (!this.isEnable() || target == null) {
            return MessagePipeline.ReplacementTag.empty(tag);
        }
        return TagResolver.resolver((String)tag, (argumentQueue, context) -> {
            Component component = this.messagePipeline.builder(target, receiver, "<display_name>").build();
            return Tag.selfClosingInserting((Component)component);
        });
    }

    public TagResolver targetTag(FPlayer receiver, @Nullable FEntity target) {
        return this.targetTag("target", receiver, target);
    }

    @Generated
    public Cooldown getModuleCooldown() {
        return this.moduleCooldown;
    }

    @Generated
    public Sound getModuleSound() {
        return this.moduleSound;
    }
}

