/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.chatsetting.builder;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.adventure.text.Component;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.guice.name.Named;
import net.flectone.pulse.library.packetevents.protocol.item.ItemStack;
import net.flectone.pulse.model.FColor;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.inventory.Inventory;
import net.flectone.pulse.module.command.chatsetting.ChatsettingModule;
import net.flectone.pulse.module.command.chatsetting.builder.MenuBuilder;
import net.flectone.pulse.module.command.chatsetting.handler.ChatsettingHandler;
import net.flectone.pulse.module.command.chatsetting.model.SubMenuItem;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.platform.controller.InventoryController;
import org.jetbrains.annotations.Nullable;

@Singleton
public class InventoryMenuBuilder
implements MenuBuilder {
    private final ChatsettingModule chatsettingModule;
    private final PlatformServerAdapter platformServerAdapter;
    private final MessagePipeline messagePipeline;
    private final InventoryController inventoryController;
    private final ChatsettingHandler chatsettingHandler;
    @Named(value="isNewerThanOrEqualsV_1_14")
    private final boolean isNewerThanOrEqualsV_1_14;

    @Override
    public void open(FPlayer fPlayer, FPlayer fTarget) {
        Localization.Command.Chatsetting localization = this.chatsettingModule.localization(fPlayer);
        Component header = this.messagePipeline.builder(fPlayer, fTarget, localization.getInventory()).build();
        Inventory.Builder inventoryBuilder = new Inventory.Builder().name(header).size(54);
        inventoryBuilder = this.createInventoryChatMenu(fPlayer, fTarget, inventoryBuilder, localization);
        inventoryBuilder = this.createInventoryFColorMenu(fPlayer, fTarget, FColor.Type.SEE, inventoryBuilder, this.chatsettingModule.config().getMenu().getSee(), localization.getMenu().getSee());
        inventoryBuilder = this.createInventoryFColorMenu(fPlayer, fTarget, FColor.Type.OUT, inventoryBuilder, this.chatsettingModule.config().getMenu().getOut(), localization.getMenu().getOut());
        for (String setting : this.chatsettingModule.config().getCheckbox().getTypes().keySet()) {
            inventoryBuilder = this.createInventoryCheckbox(fPlayer, fTarget, setting, inventoryBuilder);
        }
        this.inventoryController.open(fPlayer, inventoryBuilder.build(this.isNewerThanOrEqualsV_1_14));
    }

    private Inventory.Builder createInventoryCheckbox(FPlayer fPlayer, FPlayer fTarget, String messageType, Inventory.Builder inventoryBuilder) {
        Command.Chatsetting.Checkbox checkbox = this.chatsettingModule.config().getCheckbox();
        int slot = checkbox.getTypes().get(messageType);
        if (slot == -1) {
            return inventoryBuilder;
        }
        boolean enabled = fTarget.isSetting(messageType);
        String material = this.chatsettingModule.getCheckboxMaterial(enabled);
        String title = this.chatsettingModule.getCheckboxTitle(fPlayer, messageType, enabled);
        String lore = this.chatsettingModule.getCheckboxLore(fPlayer, enabled);
        return inventoryBuilder.addItem(slot, this.platformServerAdapter.buildItemStack(fTarget, material, title, lore)).addClickHandler(slot, (itemStack, inventory) -> {
            ChatsettingHandler.Status status = this.chatsettingHandler.handleCheckbox(fPlayer, fTarget, messageType);
            if (status == ChatsettingHandler.Status.DENIED) {
                return;
            }
            boolean currentEnabled = status.toBoolean();
            String invertMaterial = this.chatsettingModule.getCheckboxMaterial(!currentEnabled);
            String invertTitle = this.chatsettingModule.getCheckboxTitle(fPlayer, messageType, !currentEnabled);
            String invertLore = this.chatsettingModule.getCheckboxLore(fPlayer, !currentEnabled);
            ItemStack newItemStack = this.platformServerAdapter.buildItemStack(fTarget, invertMaterial, invertTitle, invertLore);
            this.inventoryController.changeItem(fPlayer, (Inventory)inventory, slot, newItemStack);
            this.chatsettingModule.saveSetting(fPlayer, messageType);
        });
    }

    private Inventory.Builder createInventoryChatMenu(FPlayer fPlayer, FPlayer fTarget, Inventory.Builder inventoryBuilder, Localization.Command.Chatsetting localization) {
        Command.Chatsetting.Menu.Chat chat = this.chatsettingModule.config().getMenu().getChat();
        int slot = chat.getSlot();
        if (slot == -1) {
            return inventoryBuilder;
        }
        String currentChat = this.chatsettingModule.getPlayerChat(fTarget);
        String material = this.chatsettingModule.config().getMenu().getMaterial();
        String[] messages = Strings.CS.replace(localization.getMenu().getChat().getItem(), "<chat>", currentChat).split("<br>");
        String title = messages.length > 0 ? messages[0] : "";
        String[] lore = messages.length > 1 ? Arrays.copyOfRange(messages, 1, messages.length) : new String[]{};
        return inventoryBuilder.addItem(slot, this.platformServerAdapter.buildItemStack(fTarget, material, title, lore)).addClickHandler(slot, (itemStack, inventory) -> this.chatsettingHandler.handleChatMenu(fPlayer, fTarget, chat, localization, this, null));
    }

    private Inventory.Builder createInventoryFColorMenu(FPlayer fPlayer, FPlayer fTarget, FColor.Type type, Inventory.Builder inventoryBuilder, Command.Chatsetting.Menu.Color color, Localization.Command.Chatsetting.Menu.SubMenu subMenu) {
        int slot = color.getSlot();
        if (slot == -1) {
            return inventoryBuilder;
        }
        String material = this.chatsettingModule.config().getMenu().getMaterial();
        String[] messages = subMenu.getItem().split("<br>");
        String title = messages.length > 0 ? messages[0] : "";
        String[] lore = messages.length > 1 ? Arrays.copyOfRange(messages, 1, messages.length) : new String[]{};
        return inventoryBuilder.addItem(slot, this.platformServerAdapter.buildItemStack(fTarget, material, title, lore)).addClickHandler(slot, (itemStack, inventory) -> this.chatsettingHandler.handleFColorMenu(fPlayer, fTarget, type, color, subMenu, this, null));
    }

    @Override
    public void openSubMenu(FPlayer fPlayer, FPlayer fTarget, Component header, Runnable closeConsumer, List<SubMenuItem> items, Function<SubMenuItem, String> getItemMessage, Consumer<SubMenuItem> onSelect, @Nullable String id) {
        Inventory.Builder inventoryBuilder = new Inventory.Builder().name(header).size(54).addCloseConsumer(inventory -> closeConsumer.run());
        for (int i = 0; i < items.size(); ++i) {
            SubMenuItem item = items.get(i);
            String message = getItemMessage.apply(item);
            String[] messages = message.split("<br>");
            String title = messages.length > 0 ? messages[0] : "";
            String[] lore = messages.length > 1 ? Arrays.copyOfRange(messages, 1, messages.length) : new String[]{};
            String material = item.material();
            inventoryBuilder.addItem(i, this.platformServerAdapter.buildItemStack(fTarget, material, title, lore));
            inventoryBuilder.addClickHandler(i, (itemStack, inventory) -> this.chatsettingHandler.handleSubMenu(fPlayer, item, () -> {
                onSelect.accept(item);
                this.inventoryController.close(fPlayer.getUuid());
                this.open(fPlayer, fTarget);
            }));
        }
        this.inventoryController.open(fPlayer, inventoryBuilder.build(this.isNewerThanOrEqualsV_1_14));
    }

    @Inject
    @Generated
    public InventoryMenuBuilder(ChatsettingModule chatsettingModule, PlatformServerAdapter platformServerAdapter, MessagePipeline messagePipeline, InventoryController inventoryController, ChatsettingHandler chatsettingHandler, @Named(value="isNewerThanOrEqualsV_1_14") boolean isNewerThanOrEqualsV_1_14) {
        this.chatsettingModule = chatsettingModule;
        this.platformServerAdapter = platformServerAdapter;
        this.messagePipeline = messagePipeline;
        this.inventoryController = inventoryController;
        this.chatsettingHandler = chatsettingHandler;
        this.isNewerThanOrEqualsV_1_14 = isNewerThanOrEqualsV_1_14;
    }
}

