/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.deletemessage;

import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.parser.standard.UUIDParser;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.deletemessage.model.DeletemessageMetadata;
import net.flectone.pulse.module.message.format.moderation.delete.DeleteModule;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class DeletemessageModule
extends AbstractModuleCommand<Localization.Command.Deletemessage> {
    private final FileResolver fileResolver;
    private final DeleteModule deleteModule;
    private final ProxySender proxySender;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptId = this.addPrompt(0, Localization.Command.Prompt::getId);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).required(promptId, UUIDParser.uuidParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        UUID uuid = (UUID)this.getArgument(commandContext, 0);
        if (!this.deleteModule.remove(fPlayer, uuid)) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Deletemessage::getNullMessage)).build());
            return;
        }
        this.proxySender.send(fPlayer, MessageType.COMMAND_DELETE, dataOutputStream -> dataOutputStream.writeUTF(uuid.toString()), UUID.randomUUID());
        this.sendMessage(((DeletemessageMetadata.DeletemessageMetadataBuilder)((DeletemessageMetadata.DeletemessageMetadataBuilder)((EventMetadata.EventMetadataBuilder)((DeletemessageMetadata.DeletemessageMetadataBuilder)((DeletemessageMetadata.DeletemessageMetadataBuilder)DeletemessageMetadata.builder().sender(fPlayer)).format(Localization.Command.Deletemessage::getFormat)).deletedUUID(uuid)).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_DELETE;
    }

    @Override
    public Command.Deletemessage config() {
        return this.fileResolver.getCommand().getDeletemessage();
    }

    @Override
    public Permission.Command.Deletemessage permission() {
        return this.fileResolver.getPermission().getCommand().getDeletemessage();
    }

    @Override
    public Localization.Command.Deletemessage localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getDeletemessage();
    }

    @Inject
    @Generated
    public DeletemessageModule(FileResolver fileResolver, DeleteModule deleteModule, ProxySender proxySender) {
        this.fileResolver = fileResolver;
        this.deleteModule = deleteModule;
        this.proxySender = proxySender;
    }
}

