/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.flectonepulse.web;

import lombok.Generated;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.spark.Service;
import net.flectone.pulse.module.command.flectonepulse.web.controller.EditorController;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class SparkServer {
    private final FileResolver fileResolver;
    private final EditorController controller;
    private Service sparkService;

    public boolean isEnable() {
        return this.sparkService != null;
    }

    public void onEnable() {
        if (this.sparkService != null) {
            this.sparkService.stop();
        }
        this.sparkService = Service.ignite();
        this.sparkService.port(this.fileResolver.getConfig().getEditor().getPort());
        this.sparkService.staticFiles.location("/");
        this.sparkService.before((req, res) -> res.type("text/html; charset=utf-8"));
        this.controller.initConfigFiles();
        this.controller.setupRoutes(this.sparkService);
        this.sparkService.init();
    }

    public void onDisable() {
        if (this.sparkService != null) {
            this.sparkService.stop();
            this.sparkService = null;
        }
    }

    @Inject
    @Generated
    public SparkServer(FileResolver fileResolver, EditorController controller) {
        this.fileResolver = fileResolver;
        this.controller = controller;
    }
}

