/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.flectonepulse.web.controller;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import net.flectone.pulse.config.YamlFile;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.spark.Request;
import net.flectone.pulse.library.spark.Response;
import net.flectone.pulse.library.spark.Service;
import net.flectone.pulse.module.command.flectonepulse.web.service.UrlService;
import net.flectone.pulse.processing.processor.YamlFileProcessor;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class EditorController {
    private final Map<String, YamlFile> configFiles = new LinkedHashMap<String, YamlFile>();
    private final Map<String, List<LocalizationFile>> localizationFiles = new HashMap<String, List<LocalizationFile>>();
    private final UrlService urlService;
    private final FileResolver fileResolver;
    private final YamlFileProcessor yamlFileProcessor;

    public void initConfigFiles() {
        this.configFiles.clear();
        this.localizationFiles.clear();
        this.configFiles.put("config.yml", this.fileResolver.getConfig());
        this.configFiles.put("commands.yml", this.fileResolver.getCommand());
        this.configFiles.put("integration.yml", this.fileResolver.getIntegration());
        this.configFiles.put("messages.yml", this.fileResolver.getMessage());
        this.configFiles.put("permissions.yml", this.fileResolver.getPermission());
        Map<String, Localization> localizationMap = this.fileResolver.getLocalizationMap();
        this.localizationFiles.put("localizations", new ArrayList());
        for (Map.Entry<String, Localization> entry : localizationMap.entrySet()) {
            String lang = entry.getKey();
            Localization localization = entry.getValue();
            this.localizationFiles.get("localizations").add(new LocalizationFile(lang + ".yml", localization));
        }
    }

    public void setupRoutes(Service spark) {
        spark.get("/", this::handleRoot);
        spark.get("/editor/:token", this::serveEditor);
        spark.get("/editor/file/:token/:fileType/:fileName", this::serveFile);
        spark.post("/editor/save/:token/:fileType/:fileName", this::handleSave);
        spark.post("/logout/:token", this::handleLogout);
    }

    private String handleRoot(Request req, Response res) {
        res.status(401);
        return this.loadTemplate("logout.html");
    }

    private String serveEditor(Request req, Response res) {
        String token = req.params("token");
        if (!this.urlService.validateToken(token)) {
            res.redirect("/");
            return null;
        }
        return this.renderEditor();
    }

    private String serveFile(Request req, Response res) {
        String token = req.params("token");
        String fileType = req.params("fileType");
        String fileName = req.params("fileName");
        if (!this.urlService.validateToken(token)) {
            res.redirect("/");
            return null;
        }
        try {
            String yamlContent = this.getFileContent(fileType, fileName);
            res.type("text/yaml; charset=utf-8");
            return yamlContent;
        }
        catch (Exception e) {
            res.status(500);
            return "Failed to load file: " + e.getMessage();
        }
    }

    private String handleSave(Request req, Response res) {
        String token = req.params("token");
        String fileType = req.params("fileType");
        String fileName = req.params("fileName");
        if (!this.urlService.validateToken(token)) {
            res.redirect("/");
            return null;
        }
        try {
            String yamlContent = req.body();
            this.saveFileContent(fileType, fileName, yamlContent);
            res.type("application/json");
            return "{\"success\": true}";
        }
        catch (Exception e) {
            res.status(500);
            res.type("application/json");
            return "{\"error\": \"Failed to save file: " + e.getMessage() + "\"}";
        }
    }

    private Object handleLogout(Request req, Response res) {
        String token = req.params("token");
        if (!this.urlService.validateToken(token)) {
            res.redirect("/");
            return null;
        }
        this.urlService.resetToken();
        res.type("application/json");
        return "{\"success\": true, \"redirect\": \"/?message=logged_out\"}";
    }

    private String getFileContent(String fileType, String fileName) throws IOException {
        if ("main".equals(fileType)) {
            YamlFile config = this.configFiles.get(fileName);
            if (config != null) {
                return Files.readString(config.getPathToFile());
            }
        } else if ("localizations".equals(fileType)) {
            List<LocalizationFile> files = this.localizationFiles.get(fileType);
            for (LocalizationFile file : files) {
                if (!file.fileName.equals(fileName)) continue;
                return Files.readString(file.localization.getPathToFile());
            }
        }
        throw new FileNotFoundException("File not found: " + fileName);
    }

    private void saveFileContent(String fileType, String fileName, String content) throws IOException {
        if ("main".equals(fileType)) {
            YamlFile config = this.configFiles.get(fileName);
            if (config != null) {
                Files.writeString(config.getPathToFile(), (CharSequence)content, new OpenOption[0]);
                this.yamlFileProcessor.reload(config);
                return;
            }
        } else if ("localizations".equals(fileType)) {
            List<LocalizationFile> files = this.localizationFiles.get(fileType);
            for (LocalizationFile file : files) {
                if (!file.fileName.equals(fileName)) continue;
                Files.writeString(file.localization.getPathToFile(), (CharSequence)content, new OpenOption[0]);
                this.yamlFileProcessor.reload(file.localization);
                return;
            }
        }
        throw new FileNotFoundException("File not found: " + fileName);
    }

    private String renderEditor() {
        StringBuilder mainFiles = new StringBuilder();
        for (String fileName : this.configFiles.keySet()) {
            mainFiles.append(String.format("<div class=\"file\" data-type=\"main\" data-name=\"%s\">%s</div>", fileName, fileName));
        }
        StringBuilder localeFiles = new StringBuilder();
        List<LocalizationFile> localizations = this.localizationFiles.get("localizations");
        for (LocalizationFile file : localizations) {
            localeFiles.append(String.format("<div class=\"file\" data-type=\"localizations\" data-name=\"%s\">%s</div>", file.fileName, file.fileName));
        }
        String template = this.loadTemplate("editor.html");
        return StringUtils.replaceEach((String)template, (String[])new String[]{"{{mainFiles}}", "{{localeFiles}}"}, (String[])new String[]{mainFiles.toString(), localeFiles.toString()});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String loadTemplate(String name) {
        try (InputStream is = this.getClass().getResourceAsStream("/web/" + name);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                string = reader.lines().collect(Collectors.joining("\n"));
            }
            return string;
        }
        catch (IOException | NullPointerException e) {
            throw new RuntimeException("Failed to load editor template", e);
        }
    }

    @Inject
    @Generated
    public EditorController(UrlService urlService, FileResolver fileResolver, YamlFileProcessor yamlFileProcessor) {
        this.urlService = urlService;
        this.fileResolver = fileResolver;
        this.yamlFileProcessor = yamlFileProcessor;
    }

    private record LocalizationFile(String fileName, Localization localization) {
    }
}

