/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.kick;

import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.execution.pipeline.MessagePipeline;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.ModerationMetadata;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class KickModule
extends AbstractModuleCommand<Localization.Command.Kick> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final ModerationService moderationService;
    private final ModerationMessageFormatter moderationMessageFormatter;
    private final CommandParserProvider commandParserProvider;
    private final MessagePipeline messagePipeline;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).required(promptPlayer, this.commandParserProvider.playerParser()).optional(promptMessage, this.commandParserProvider.nativeMessageParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String playerName = (String)this.getArgument(commandContext, 0);
        FPlayer fTarget = this.fPlayerService.getFPlayer(playerName);
        if (!fTarget.isOnline()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Kick::getNullPlayer)).build());
            return;
        }
        String promptMessage = this.getPrompt(1);
        Optional optionalReason = commandContext.optional(promptMessage);
        String reason = optionalReason.orElse(null);
        Moderation kick = this.moderationService.kick(fTarget, reason, fPlayer.getId());
        if (kick == null) {
            return;
        }
        this.kick(fPlayer, fTarget, kick);
        this.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().sender(fTarget)).format(this.buildFormat(kick))).moderation(kick)).destination(this.config().getDestination())).range(this.config().getRange())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeAsJson(kick))).integration(string -> this.moderationMessageFormatter.replacePlaceholders((String)string, FPlayer.UNKNOWN, kick))).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_KICK;
    }

    @Override
    public Command.Kick config() {
        return this.fileResolver.getCommand().getKick();
    }

    @Override
    public Permission.Command.Kick permission() {
        return this.fileResolver.getPermission().getCommand().getKick();
    }

    @Override
    public Localization.Command.Kick localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getKick();
    }

    public BiFunction<FPlayer, Localization.Command.Kick, String> buildFormat(Moderation kick) {
        return (fReceiver, message) -> this.moderationMessageFormatter.replacePlaceholders(message.getServer(), (FPlayer)fReceiver, kick);
    }

    public void kick(FEntity fModerator, FPlayer fReceiver, Moderation kick) {
        if (this.isModuleDisabledFor(fModerator)) {
            return;
        }
        String format = this.moderationMessageFormatter.replacePlaceholders(this.localization(fReceiver).getPerson(), fReceiver, kick);
        this.fPlayerService.kick(fReceiver, this.messagePipeline.builder(fReceiver, format).build());
    }

    @Inject
    @Generated
    public KickModule(FileResolver fileResolver, FPlayerService fPlayerService, ModerationService moderationService, ModerationMessageFormatter moderationMessageFormatter, CommandParserProvider commandParserProvider, MessagePipeline messagePipeline) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.moderationService = moderationService;
        this.moderationMessageFormatter = moderationMessageFormatter;
        this.commandParserProvider = commandParserProvider;
        this.messagePipeline = messagePipeline;
    }
}

