/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.mail;

import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.adventure.text.minimessage.tag.resolver.TagResolver;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.mail.listener.MailPulseListener;
import net.flectone.pulse.module.command.mail.model.Mail;
import net.flectone.pulse.module.command.mail.model.MailMetadata;
import net.flectone.pulse.module.command.tell.TellModule;
import net.flectone.pulse.module.integration.IntegrationModule;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.platform.sender.DisableSender;
import net.flectone.pulse.platform.sender.IgnoreSender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class MailModule
extends AbstractModuleCommand<Localization.Command.Mail>
implements PulseListener {
    private final FileResolver fileResolver;
    private final TellModule tellModule;
    private final IntegrationModule integrationModule;
    private final FPlayerService fPlayerService;
    private final CommandParserProvider commandParserProvider;
    private final ListenerRegistry listenerRegistry;
    private final IgnoreSender ignoreSender;
    private final DisableSender disableSender;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptMessage = this.addPrompt(1, Localization.Command.Prompt::getMessage);
        this.registerCommand(manager -> manager.permission(this.permission().getName()).required(promptPlayer, this.commandParserProvider.playerParser(true)).required(promptMessage, this.commandParserProvider.nativeMessageParser()));
        this.listenerRegistry.register(MailPulseListener.class);
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String playerName = (String)this.getArgument(commandContext, 0);
        FPlayer fReceiver = this.fPlayerService.getFPlayer(playerName);
        if (fReceiver.isUnknown()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mail::getNullPlayer)).build());
            return;
        }
        if (fReceiver.isOnline() && this.integrationModule.canSeeVanished(fReceiver, fPlayer)) {
            if (!this.tellModule.isEnable()) {
                this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mail::getOnlinePlayer)).build());
                return;
            }
            this.tellModule.execute(fPlayer, commandContext);
            return;
        }
        this.fPlayerService.loadIgnoresIfOffline(fReceiver);
        if (this.ignoreSender.sendIfIgnored(fPlayer, fReceiver)) {
            return;
        }
        this.fPlayerService.loadSettingsIfOffline(fReceiver);
        if (this.disableSender.sendIfDisabled(fPlayer, fReceiver, this.messageType())) {
            return;
        }
        String message = (String)this.getArgument(commandContext, 1);
        Mail mail = this.fPlayerService.saveAndGetMail(fPlayer, fReceiver, message);
        if (mail == null) {
            return;
        }
        this.sendMessage(((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((EventMetadata.EventMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)((MailMetadata.MailMetadataBuilder)MailMetadata.builder().sender(fPlayer)).format(s -> Strings.CS.replaceOnce(s.getSender(), "<id>", String.valueOf(mail.id())))).mail(mail)).target(fReceiver)).message(message)).destination(this.config().getDestination())).sound(this.getModuleSound())).tagResolvers(fResolver -> new TagResolver[]{this.targetTag((FPlayer)fResolver, fReceiver)})).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_MAIL;
    }

    @Override
    public Command.Mail config() {
        return this.fileResolver.getCommand().getMail();
    }

    @Override
    public Permission.Command.Mail permission() {
        return this.fileResolver.getPermission().getCommand().getMail();
    }

    @Override
    public Localization.Command.Mail localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getMail();
    }

    @Inject
    @Generated
    public MailModule(FileResolver fileResolver, TellModule tellModule, IntegrationModule integrationModule, FPlayerService fPlayerService, CommandParserProvider commandParserProvider, ListenerRegistry listenerRegistry, IgnoreSender ignoreSender, DisableSender disableSender) {
        this.fileResolver = fileResolver;
        this.tellModule = tellModule;
        this.integrationModule = integrationModule;
        this.fPlayerService = fPlayerService;
        this.commandParserProvider = commandParserProvider;
        this.listenerRegistry = listenerRegistry;
        this.ignoreSender = ignoreSender;
        this.disableSender = disableSender;
    }
}

