/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.mute;

import java.time.Duration;
import java.util.Optional;
import java.util.function.BiFunction;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.cloud.cloud.type.tuple.Pair;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.event.ModerationMetadata;
import net.flectone.pulse.model.util.Moderation;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.platform.formatter.ModerationMessageFormatter;
import net.flectone.pulse.platform.provider.CommandParserProvider;
import net.flectone.pulse.platform.sender.ProxySender;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.service.ModerationService;
import net.flectone.pulse.util.constant.MessageType;

@Singleton
public class MuteModule
extends AbstractModuleCommand<Localization.Command.Mute> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final ModerationService moderationService;
    private final ModerationMessageFormatter moderationMessageFormatter;
    private final CommandParserProvider commandParserProvider;
    private final ProxySender proxySender;

    @Override
    public void onEnable() {
        super.onEnable();
        String promptPlayer = this.addPrompt(0, Localization.Command.Prompt::getPlayer);
        String promptReason = this.addPrompt(1, Localization.Command.Prompt::getReason);
        String promptTime = this.addPrompt(2, Localization.Command.Prompt::getTime);
        this.registerCommand(commandBuilder -> commandBuilder.permission(this.permission().getName()).required(promptPlayer, this.commandParserProvider.playerParser(this.config().isSuggestOfflinePlayers())).optional(promptTime + " " + promptReason, this.commandParserProvider.durationReasonParser()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        String reason;
        long time;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        String target = (String)this.getArgument(commandContext, 0);
        String promptReason = this.getPrompt(1);
        String promptTime = this.getPrompt(2);
        Optional optionalTime = commandContext.optional(promptTime + " " + promptReason);
        Pair timeReasonPair = optionalTime.orElse(Pair.of((Object)Duration.ofHours(1L).toMillis(), null));
        long l = time = (Long)timeReasonPair.first() == -1L ? Duration.ofHours(1L).toMillis() : ((Long)timeReasonPair.first()).longValue();
        if (time < 1L) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mute::getNullTime)).build());
            return;
        }
        FPlayer fTarget = this.fPlayerService.getFPlayer(target);
        if (fTarget.isUnknown()) {
            this.sendErrorMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fPlayer)).format(Localization.Command.Mute::getNullPlayer)).build());
            return;
        }
        long databaseTime = time + System.currentTimeMillis();
        Moderation mute = this.moderationService.mute(fTarget, databaseTime, reason = (String)timeReasonPair.second(), fPlayer.getId());
        if (mute == null) {
            return;
        }
        this.proxySender.send(fTarget, MessageType.SYSTEM_MUTE);
        this.sendMessage(((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((EventMetadata.EventMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)((ModerationMetadata.ModerationMetadataBuilder)ModerationMetadata.builder().sender(fTarget)).format(this.buildFormat(mute))).moderation(mute)).range(this.config().getRange())).destination(this.config().getDestination())).sound(this.getModuleSound())).proxy(dataOutputStream -> dataOutputStream.writeAsJson(mute))).integration(string -> this.moderationMessageFormatter.replacePlaceholders((String)string, FPlayer.UNKNOWN, mute))).build());
        this.sendForTarget(fPlayer, fTarget, mute);
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_MUTE;
    }

    @Override
    public Command.Mute config() {
        return this.fileResolver.getCommand().getMute();
    }

    @Override
    public Permission.Command.Mute permission() {
        return this.fileResolver.getPermission().getCommand().getMute();
    }

    @Override
    public Localization.Command.Mute localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getMute();
    }

    public BiFunction<FPlayer, Localization.Command.Mute, String> buildFormat(Moderation mute) {
        return (fReceiver, message) -> this.moderationMessageFormatter.replacePlaceholders(message.getServer(), (FPlayer)fReceiver, mute);
    }

    public void sendForTarget(FEntity fModerator, FPlayer fReceiver, Moderation mute) {
        if (this.isModuleDisabledFor(fModerator)) {
            return;
        }
        this.sendMessage(((EventMetadata.EventMetadataBuilder)((EventMetadata.EventMetadataBuilder)this.metadataBuilder().sender(fReceiver)).format(s -> this.moderationMessageFormatter.replacePlaceholders(s.getPerson(), fReceiver, mute))).build());
    }

    @Inject
    @Generated
    public MuteModule(FileResolver fileResolver, FPlayerService fPlayerService, ModerationService moderationService, ModerationMessageFormatter moderationMessageFormatter, CommandParserProvider commandParserProvider, ProxySender proxySender) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.moderationService = moderationService;
        this.moderationMessageFormatter = moderationMessageFormatter;
        this.commandParserProvider = commandParserProvider;
        this.proxySender = proxySender;
    }
}

