/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.spy;

import java.util.List;
import java.util.Map;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.module.command.spy.SpyListener;
import net.flectone.pulse.module.command.spy.SpyModule;
import net.flectone.pulse.platform.registry.BukkitListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Singleton
public class BukkitSpyModule
extends SpyModule {
    private final FPlayerService fPlayerService;
    private final BukkitListenerRegistry bukkitListenerManager;

    @Inject
    public BukkitSpyModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker, BukkitListenerRegistry bukkitListenerManager) {
        super(fileResolver, fPlayerService, permissionChecker);
        this.fPlayerService = fPlayerService;
        this.bukkitListenerManager = bukkitListenerManager;
    }

    @Override
    public void onEnable() {
        super.onEnable();
        this.bukkitListenerManager.register(SpyListener.class, Event.Priority.NORMAL);
    }

    @Async
    public void check(PlayerCommandPreprocessEvent event) {
        if (!this.isEnable()) {
            return;
        }
        Map<String, List<String>> categories = this.config().getCategories();
        if (categories.get("command") == null) {
            return;
        }
        String action = event.getMessage();
        if (!action.isEmpty()) {
            action = action.split(" ")[0].substring(1);
        }
        if (!categories.get("command").contains(action)) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        this.spy(fPlayer, action, event.getMessage());
    }

    @Async
    public void check(InventoryClickEvent event) {
        if (!this.isEnable()) {
            return;
        }
        Map<String, List<String>> categories = this.config().getCategories();
        if (categories.get("action") == null) {
            return;
        }
        if (!categories.get("action").contains("anvil")) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getClickedInventory() instanceof AnvilInventory)) {
            return;
        }
        if (event.getSlot() != 2) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        FPlayer fPlayer = this.fPlayerService.getFPlayer(player);
        ItemStack itemStack = event.getCurrentItem();
        ItemMeta itemMeta = itemStack.getItemMeta();
        String itemName = itemMeta == null ? itemStack.getType().name() : itemMeta.getDisplayName();
        this.spy(fPlayer, "anvil", itemName);
    }

    @Async
    public void check(PlayerEditBookEvent event) {
        if (!this.isEnable()) {
            return;
        }
        Map<String, List<String>> categories = this.config().getCategories();
        if (categories.get("action") == null) {
            return;
        }
        if (!categories.get("action").contains("book")) {
            return;
        }
        Player player = event.getPlayer();
        FPlayer fPlayer = this.fPlayerService.getFPlayer(player);
        BookMeta bookMeta = event.getNewBookMeta();
        this.spy(fPlayer, "book", String.join((CharSequence)" ", bookMeta.getPages()));
        if (bookMeta.getTitle() == null) {
            return;
        }
        this.spy(fPlayer, "book", bookMeta.getTitle());
    }

    @Async
    public void check(SignChangeEvent event) {
        if (!this.isEnable()) {
            return;
        }
        Map<String, List<String>> categories = this.config().getCategories();
        if (categories.get("action") == null) {
            return;
        }
        if (!categories.get("action").contains("sign")) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        String message = String.join((CharSequence)" ", event.getLines());
        this.spy(fPlayer, "sign", message);
    }

    @Async
    public void check(AsyncPlayerChatEvent event) {
        if (!this.isEnable()) {
            return;
        }
        FPlayer fPlayer = this.fPlayerService.getFPlayer(event.getPlayer());
        String message = event.getMessage();
        this.checkChat(fPlayer, "chat", message);
    }
}

