/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.command.spy;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import net.flectone.pulse.config.Command;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.Strings;
import net.flectone.pulse.library.cloud.cloud.context.CommandContext;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.module.AbstractModuleCommand;
import net.flectone.pulse.module.command.spy.model.SpyMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.service.FPlayerService;
import net.flectone.pulse.util.checker.PermissionChecker;
import net.flectone.pulse.util.constant.MessageType;
import net.flectone.pulse.util.constant.SettingText;

@Singleton
public class SpyModule
extends AbstractModuleCommand<Localization.Command.Spy> {
    private final FileResolver fileResolver;
    private final FPlayerService fPlayerService;
    private final PermissionChecker permissionChecker;

    @Override
    public void onEnable() {
        super.onEnable();
        this.registerCommand(manager -> manager.permission(this.permission().getName()));
    }

    @Override
    public void execute(FPlayer fPlayer, CommandContext<FPlayer> commandContext) {
        boolean turnedBefore;
        if (this.isModuleDisabledFor(fPlayer, true)) {
            return;
        }
        boolean bl = turnedBefore = fPlayer.getSetting(SettingText.SPY_STATUS) != null;
        if (turnedBefore) {
            fPlayer.removeSetting(SettingText.SPY_STATUS);
        } else {
            fPlayer.setSetting(SettingText.SPY_STATUS, "1");
        }
        this.fPlayerService.saveOrUpdateSetting(fPlayer, SettingText.SPY_STATUS);
        this.sendMessage(((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)SpyMetadata.builder().sender(fPlayer)).format(s -> !turnedBefore ? s.getFormatTrue() : s.getFormatFalse())).turned(!turnedBefore)).action("turning")).destination(this.config().getDestination())).sound(this.getModuleSound())).build());
    }

    @Override
    public MessageType messageType() {
        return MessageType.COMMAND_SPY;
    }

    @Override
    public Command.Spy config() {
        return this.fileResolver.getCommand().getSpy();
    }

    @Override
    public Permission.Command.Spy permission() {
        return this.fileResolver.getPermission().getCommand().getSpy();
    }

    @Override
    public Localization.Command.Spy localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getCommand().getSpy();
    }

    public void checkChat(FPlayer fPlayer, String chat, String message) {
        if (!this.isEnable()) {
            return;
        }
        Map<String, List<String>> categories = this.config().getCategories();
        if (categories.get("action") == null) {
            return;
        }
        if (!categories.get("action").contains(chat)) {
            return;
        }
        this.spy(fPlayer, chat, message);
    }

    public void spy(FPlayer fPlayer, String action, String message) {
        if (!this.isEnable()) {
            return;
        }
        this.sendMessage(((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((EventMetadata.EventMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)((SpyMetadata.SpyMetadataBuilder)SpyMetadata.builder().sender(fPlayer)).format(this.replaceAction(action))).turned(true)).action(action)).range(this.config().getRange())).destination(this.config().getDestination())).message(message)).filter(this.createFilter(fPlayer))).proxy(dataOutputStream -> {
            dataOutputStream.writeString(action);
            dataOutputStream.writeString(message);
        })).integration(string -> Strings.CS.replace(string, "<action>", action))).build());
    }

    public Predicate<FPlayer> createFilter(FPlayer fPlayer) {
        return fReceiver -> !fPlayer.equals(fReceiver) && this.permissionChecker.check((FEntity)fReceiver, this.getPermission()) && fReceiver.getSetting(SettingText.SPY_STATUS) != null && fReceiver.isOnline();
    }

    public Function<Localization.Command.Spy, String> replaceAction(String action) {
        return message -> Strings.CS.replace(message.getFormatLog(), "<action>", action);
    }

    @Inject
    @Generated
    public SpyModule(FileResolver fileResolver, FPlayerService fPlayerService, PermissionChecker permissionChecker) {
        this.fileResolver = fileResolver;
        this.fPlayerService = fPlayerService;
        this.permissionChecker = permissionChecker;
    }
}

