/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.advancedban;

import lombok.Generated;
import me.leoko.advancedban.manager.PunishmentManager;
import me.leoko.advancedban.manager.UUIDManager;
import me.leoko.advancedban.utils.Punishment;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.util.logging.FLogger;

@Singleton
public class AdvancedBanIntegration
implements FIntegration {
    private final FLogger fLogger;
    private boolean hooked;

    @Override
    public void hook() {
        this.hooked = true;
        this.fLogger.info("\u2714 AdvancedBan hooked");
    }

    @Override
    public void unhook() {
        this.hooked = false;
        this.fLogger.info("\u2716 AdvancedBan unhooked");
    }

    public boolean isMuted(FEntity fEntity) {
        return PunishmentManager.get().isMuted(this.getUUID(fEntity));
    }

    public ExternalModeration getMute(FEntity fEntity) {
        Punishment punishment = PunishmentManager.get().getMute(this.getUUID(fEntity));
        if (punishment == null) {
            return null;
        }
        return new ExternalModeration(fEntity.getName(), punishment.getOperator(), punishment.getReason(), punishment.getId(), punishment.getStart(), punishment.getEnd(), !punishment.getType().isTemp());
    }

    private String getUUID(FEntity fEntity) {
        return UUIDManager.get().getUUID(fEntity.getName());
    }

    @Inject
    @Generated
    public AdvancedBanIntegration(FLogger fLogger) {
        this.fLogger = fLogger;
    }

    @Generated
    public boolean isHooked() {
        return this.hooked;
    }
}

