/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.advancedban;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.util.ExternalModeration;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.advancedban.AdvancedBanIntegration;
import net.flectone.pulse.module.integration.advancedban.listener.AdvancedBanPulseListener;
import net.flectone.pulse.platform.registry.ListenerRegistry;
import net.flectone.pulse.processing.resolver.FileResolver;

@Singleton
public class AdvancedBanModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final AdvancedBanIntegration advancedBanIntegration;
    private final ListenerRegistry listenerRegistry;

    @Override
    public void onEnable() {
        super.onEnable();
        this.advancedBanIntegration.hook();
        this.listenerRegistry.register(AdvancedBanPulseListener.class);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.advancedBanIntegration.unhook();
    }

    @Override
    public Integration.Advancedban config() {
        return this.fileResolver.getIntegration().getAdvancedban();
    }

    @Override
    public Permission.Integration.Advancedban permission() {
        return this.fileResolver.getPermission().getIntegration().getAdvancedban();
    }

    public boolean isMuted(FEntity fEntity) {
        if (this.isModuleDisabledFor(fEntity)) {
            return false;
        }
        return this.advancedBanIntegration.isMuted(fEntity);
    }

    public ExternalModeration getMute(FEntity fEntity) {
        if (this.isModuleDisabledFor(fEntity)) {
            return null;
        }
        return this.advancedBanIntegration.getMute(fEntity);
    }

    public boolean isHooked() {
        return this.advancedBanIntegration.isHooked();
    }

    @Inject
    @Generated
    public AdvancedBanModule(FileResolver fileResolver, AdvancedBanIntegration advancedBanIntegration, ListenerRegistry listenerRegistry) {
        this.fileResolver = fileResolver;
        this.advancedBanIntegration = advancedBanIntegration;
        this.listenerRegistry = listenerRegistry;
    }
}

