/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.advancedban.listener;

import java.util.Set;
import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.event.module.ModuleEnableEvent;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.command.ban.BanModule;
import net.flectone.pulse.module.command.banlist.BanlistModule;
import net.flectone.pulse.module.command.kick.KickModule;
import net.flectone.pulse.module.command.mute.MuteModule;
import net.flectone.pulse.module.command.mutelist.MutelistModule;
import net.flectone.pulse.module.command.unban.UnbanModule;
import net.flectone.pulse.module.command.unmute.UnmuteModule;
import net.flectone.pulse.module.command.unwarn.UnwarnModule;
import net.flectone.pulse.module.command.warn.WarnModule;
import net.flectone.pulse.module.command.warnlist.WarnlistModule;
import net.flectone.pulse.module.integration.advancedban.AdvancedBanModule;

@Singleton
public class AdvancedBanPulseListener
implements PulseListener {
    private final Set<Class<? extends AbstractModule>> banModules = Set.of(BanModule.class, BanlistModule.class, UnbanModule.class);
    private final Set<Class<? extends AbstractModule>> muteModules = Set.of(MuteModule.class, MutelistModule.class, UnmuteModule.class);
    private final Set<Class<? extends AbstractModule>> warnModules = Set.of(WarnModule.class, WarnlistModule.class, UnwarnModule.class);
    private final Set<Class<? extends AbstractModule>> kickModules = Set.of(KickModule.class);
    private final AdvancedBanModule advancedBanModule;

    @Pulse
    public void onModuleEnableEvent(ModuleEnableEvent event) {
        if (!this.advancedBanModule.isHooked()) {
            return;
        }
        AbstractModule eventModule = event.getModule();
        Integration.Advancedban config = this.advancedBanModule.config();
        if (config.isDisableFlectonepulseBan() && this.isInstanceOfAny(eventModule, this.banModules) || config.isDisableFlectonepulseMute() && this.isInstanceOfAny(eventModule, this.muteModules) || config.isDisableFlectonepulseWarn() && this.isInstanceOfAny(eventModule, this.warnModules) || config.isDisableFlectonepulseKick() && this.isInstanceOfAny(eventModule, this.kickModules)) {
            event.setCancelled(true);
        }
    }

    private boolean isInstanceOfAny(AbstractModule module, Set<Class<? extends AbstractModule>> classes) {
        return classes.stream().anyMatch(clazz -> clazz.isInstance(module));
    }

    @Inject
    @Generated
    public AdvancedBanPulseListener(AdvancedBanModule advancedBanModule) {
        this.advancedBanModule = advancedBanModule;
    }
}

