/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.deepl;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Injector;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.library.libby.Library;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.deepl.DeeplIntegration;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.processing.resolver.LibraryResolver;
import net.flectone.pulse.processing.resolver.ReflectionResolver;

@Singleton
public class DeeplModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final ReflectionResolver reflectionResolver;
    private final Injector injector;

    @Override
    public void onEnable() {
        super.onEnable();
        this.reflectionResolver.hasClassOrElse("com.deepl.api.DeepLClient", this::loadLibraries);
        ((DeeplIntegration)this.injector.getInstance(DeeplIntegration.class)).hook();
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ((DeeplIntegration)this.injector.getInstance(DeeplIntegration.class)).unhook();
    }

    @Override
    public Integration.Deepl config() {
        return this.fileResolver.getIntegration().getDeepl();
    }

    @Override
    public Permission.Integration.Deepl permission() {
        return this.fileResolver.getPermission().getIntegration().getDeepl();
    }

    public String translate(FPlayer sender, String source, String target, String text) {
        if (this.isModuleDisabledFor(sender)) {
            return text;
        }
        return ((DeeplIntegration)this.injector.getInstance(DeeplIntegration.class)).translate(source, target, text);
    }

    private void loadLibraries(LibraryResolver libraryResolver) {
        libraryResolver.loadLibrary(Library.builder().groupId("com{}deepl{}api").artifactId("deepl-java").version("1.10.3").repository("https://repo1.maven.org/maven2/").resolveTransitiveDependencies(true).build());
    }

    @Inject
    @Generated
    public DeeplModule(FileResolver fileResolver, ReflectionResolver reflectionResolver, Injector injector) {
        this.fileResolver = fileResolver;
        this.reflectionResolver = reflectionResolver;
        this.injector = injector;
    }
}

