/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.discord.listener;

import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import java.util.Optional;
import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.config.localization.Localization;
import net.flectone.pulse.library.apache.lang3.StringUtils;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.entity.FPlayer;
import net.flectone.pulse.model.event.EventMetadata;
import net.flectone.pulse.model.util.Range;
import net.flectone.pulse.module.integration.discord.listener.EventListener;
import net.flectone.pulse.module.integration.discord.model.DiscordMetadata;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.MessageType;
import reactor.core.publisher.Mono;

@Singleton
public class MessageCreateListener
extends EventListener<MessageCreateEvent> {
    private final FileResolver fileResolver;

    @Override
    public Class<MessageCreateEvent> getEventType() {
        return MessageCreateEvent.class;
    }

    @Override
    public Mono<MessageCreateEvent> execute(MessageCreateEvent event) {
        Message discordMessage = event.getMessage();
        String channel = this.config().getMessageChannel().get(MessageType.FROM_DISCORD_TO_MINECRAFT.name());
        if (channel == null) {
            return Mono.empty();
        }
        if (!channel.equals(discordMessage.getChannelId().asString())) {
            return Mono.empty();
        }
        Optional user = event.getMember();
        if (user.isEmpty() || ((Member)user.get()).isBot()) {
            return Mono.empty();
        }
        String message = discordMessage.getContent();
        if (message.isEmpty()) {
            if (discordMessage.getAttachments().isEmpty()) {
                return Mono.empty();
            }
            message = String.join((CharSequence)" ", discordMessage.getAttachments().stream().map(Attachment::getUrl).toList());
        }
        this.sendMessage((Member)user.get(), message);
        return Mono.empty();
    }

    @Async
    public void sendMessage(Member member, String message) {
        String globalName = member.getGlobalName().orElse("");
        String nickname = member.getNickname().orElse("");
        String displayName = member.getDisplayName();
        String userName = member.getUsername();
        this.sendMessage(((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((EventMetadata.EventMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)((DiscordMetadata.DiscordMetadataBuilder)DiscordMetadata.builder().sender(FPlayer.UNKNOWN)).format(string -> StringUtils.replaceEach((String)string.getForMinecraft(), (String[])new String[]{"<name>", "<global_name>", "<nickname>", "<display_name>", "<user_name>"}, (String[])new String[]{globalName, globalName, nickname, displayName, userName}))).globalName(globalName)).nickname(nickname)).displayName(displayName)).userName(userName)).range(Range.get(Range.Type.PROXY))).destination(this.config().getDestination())).message(message)).sound(this.getModuleSound())).integration(string -> StringUtils.replaceEach((String)string, (String[])new String[]{"<name>", "<global_name>", "<nickname>", "<display_name>", "<user_name>"}, (String[])new String[]{globalName, globalName, nickname, displayName, userName}))).build());
    }

    @Override
    public void onEnable() {
    }

    @Override
    public Integration.Discord config() {
        return this.fileResolver.getIntegration().getDiscord();
    }

    @Override
    public Permission.Integration.Discord permission() {
        return this.fileResolver.getPermission().getIntegration().getDiscord();
    }

    @Override
    public Localization.Integration.Discord localization(FEntity sender) {
        return this.fileResolver.getLocalization(sender).getIntegration().getDiscord();
    }

    @Inject
    @Generated
    public MessageCreateListener(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }
}

