/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.geyser;

import lombok.Generated;
import net.flectone.pulse.annotation.Async;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.util.logging.FLogger;
import org.geysermc.geyser.api.GeyserApi;

@Singleton
public class GeyserIntegration
implements FIntegration {
    private final FLogger fLogger;
    private GeyserApi geyserApi;

    @Override
    public void hook() {
        this.geyserApi = GeyserApi.api();
        this.fLogger.info("\u2714 Geyser hooked");
    }

    @Async(delay=20L)
    public void hookLater() {
        this.hook();
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 Geyser unhooked");
    }

    public boolean isBedrockPlayer(FEntity fPlayer) {
        if (this.geyserApi == null) {
            return false;
        }
        return this.geyserApi.isBedrockPlayer(fPlayer.getUuid());
    }

    @Inject
    @Generated
    public GeyserIntegration(FLogger fLogger) {
        this.fLogger = fLogger;
    }
}

