/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.geyser;

import lombok.Generated;
import net.flectone.pulse.config.Integration;
import net.flectone.pulse.config.Permission;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.module.AbstractModule;
import net.flectone.pulse.module.integration.geyser.GeyserIntegration;
import net.flectone.pulse.platform.adapter.PlatformServerAdapter;
import net.flectone.pulse.processing.resolver.FileResolver;
import net.flectone.pulse.util.constant.PlatformType;

@Singleton
public class GeyserModule
extends AbstractModule {
    private final FileResolver fileResolver;
    private final GeyserIntegration geyserIntegration;
    private final PlatformServerAdapter platformServerAdapter;

    @Override
    public void onEnable() {
        super.onEnable();
        if (this.platformServerAdapter.getPlatformType() == PlatformType.FABRIC) {
            this.geyserIntegration.hookLater();
        } else {
            this.geyserIntegration.hook();
        }
    }

    @Override
    public void onDisable() {
        super.onDisable();
        this.geyserIntegration.unhook();
    }

    @Override
    public Integration.Geyser config() {
        return this.fileResolver.getIntegration().getGeyser();
    }

    @Override
    public Permission.Integration.Geyser permission() {
        return this.fileResolver.getPermission().getIntegration().getGeyser();
    }

    public boolean isBedrockPlayer(FEntity fPlayer) {
        if (this.isModuleDisabledFor(fPlayer)) {
            return false;
        }
        return this.geyserIntegration.isBedrockPlayer(fPlayer);
    }

    @Inject
    @Generated
    public GeyserModule(FileResolver fileResolver, GeyserIntegration geyserIntegration, PlatformServerAdapter platformServerAdapter) {
        this.fileResolver = fileResolver;
        this.geyserIntegration = geyserIntegration;
        this.platformServerAdapter = platformServerAdapter;
    }
}

