/*
 * Decompiled with CFR 0.152.
 */
package net.flectone.pulse.module.integration.interactivechat;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.api.InteractiveChatAPI;
import com.loohp.interactivechat.data.PlayerDataManager;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.listeners.ChatEvents;
import com.loohp.interactivechat.registry.Registry;
import java.util.UUID;
import lombok.Generated;
import net.flectone.pulse.annotation.Pulse;
import net.flectone.pulse.library.adventure.text.minimessage.MiniMessage;
import net.flectone.pulse.library.guice.Inject;
import net.flectone.pulse.library.guice.Singleton;
import net.flectone.pulse.listener.PulseListener;
import net.flectone.pulse.model.entity.FEntity;
import net.flectone.pulse.model.event.Event;
import net.flectone.pulse.model.event.message.MessageFormattingEvent;
import net.flectone.pulse.module.integration.FIntegration;
import net.flectone.pulse.processing.context.MessageContext;
import net.flectone.pulse.util.constant.MessageFlag;
import net.flectone.pulse.util.logging.FLogger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Singleton
public class InteractiveChatIntegration
implements FIntegration,
PulseListener {
    private final FLogger fLogger;

    @Override
    public void hook() {
        this.fLogger.info("\u2714 InteractiveChat hooked");
    }

    @Override
    public void unhook() {
        this.fLogger.info("\u2716 InteractiveChat unhooked");
    }

    public String checkMention(FEntity fSender, String message) {
        Player sender = Bukkit.getPlayer((UUID)fSender.getUuid());
        if (sender == null) {
            return message;
        }
        PlayerDataManager.PlayerData data = InteractiveChat.playerDataManager.getPlayerData(sender);
        if (InteractiveChat.allowMention && (data == null || !data.isMentionDisabled())) {
            String processedMessage;
            if (!InteractiveChat.disableEveryone && (processedMessage = ChatEvents.checkMentionEveryone((String)"chat", (String)message, (Player)sender)) != null) {
                return processedMessage;
            }
            if (!InteractiveChat.disableHere && (processedMessage = ChatEvents.checkMentionHere((String)"chat", (String)message, (Player)sender)) != null) {
                return processedMessage;
            }
            processedMessage = ChatEvents.checkMentionPlayers((String)"chat", (String)message, (Player)sender);
            if (processedMessage != null) {
                return processedMessage;
            }
        }
        return message;
    }

    private String markSender(FEntity fSender, String message) {
        UUID sender = fSender.getUuid();
        if (Bukkit.getPlayer((UUID)fSender.getUuid()) == null) {
            return message;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : message.split(" ")) {
            if (!(Registry.MENTION_TAG_CONVERTER.containsTags(string) || string.contains("<cmd=") || string.contains("<chat="))) {
                string = InteractiveChatAPI.markSender((String)string, (UUID)sender);
            }
            stringBuilder.append(string).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public boolean sendMessage(FEntity fReceiver, net.flectone.pulse.library.adventure.text.Component message) {
        Player receiver = Bukkit.getPlayer((UUID)fReceiver.getUuid());
        if (receiver == null) {
            return false;
        }
        try {
            String serializedMessage = (String)MiniMessage.miniMessage().serialize(message);
            Component deserializedMessage = com.loohp.interactivechat.libs.net.kyori.adventure.text.minimessage.MiniMessage.miniMessage().deserialize((Object)serializedMessage);
            InteractiveChatAPI.sendMessage((CommandSender)receiver, (Component)deserializedMessage);
        }
        catch (Exception ignored) {
            this.fLogger.warning("An error occurred when sending messages via InteractiveChat, message will be sent via Flectonepulse");
            return false;
        }
        return true;
    }

    @Pulse(priority=Event.Priority.LOWEST)
    public void onMessageFormattingEvent(MessageFormattingEvent event) {
        MessageContext messageContext = event.getContext();
        if (!messageContext.isFlag(MessageFlag.INTERACTIVE_CHAT)) {
            return;
        }
        FEntity sender = messageContext.getSender();
        String message = messageContext.getMessage();
        message = this.markSender(sender, message);
        messageContext.setMessage(message);
    }

    @Inject
    @Generated
    public InteractiveChatIntegration(FLogger fLogger) {
        this.fLogger = fLogger;
    }
}

